/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ClasspathTemplateResource;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.utils.IO;
import org.rythmengine.utils.S;

public class FileTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private ILogger logger = Logger.get(FileTemplateResource.class);
    private File file;
    private String key;
    private String tagName;

    @Override
    protected long defCheckInterval() {
        return 5000L;
    }

    public FileTemplateResource(String path) {
        this(path, null);
    }

    public FileTemplateResource(String path, RythmEngine engine) {
        super(engine);
        File home = this.engine().conf().templateHome();
        File f = null;
        if (null != home) {
            f = new File(home, path);
        }
        if (null == f || !f.canRead()) {
            f = new File(path);
        }
        this.file = f;
        this.key = path;
    }

    public FileTemplateResource(File templateFile) {
        this(templateFile, null);
    }

    public FileTemplateResource(File templateFile, RythmEngine engine) {
        super(engine);
        String homePath;
        this.file = templateFile;
        this.key = this.file.getPath();
        File home = this.engine().conf().templateHome();
        String string = homePath = null == home ? null : home.getPath();
        if (null != homePath && this.key.startsWith(homePath)) {
            this.key = this.key.replace(homePath, "");
            if (this.key.startsWith("/") || this.key.startsWith("\\")) {
                this.key = this.key.substring(1);
            }
        }
    }

    private static String retrieveTagName(File tagHome, File tagFile) {
        String tagPath = tagHome.getAbsolutePath();
        String filePath = tagFile.getAbsolutePath();
        String tagName = null;
        if (filePath.startsWith(tagPath)) {
            tagName = filePath.substring(tagPath.length());
            while (tagName.startsWith("/") || tagName.startsWith("\\")) {
                tagName = tagName.substring(1);
            }
            tagName = tagName.replace('\\', '.');
            tagName = tagName.replace('/', '.');
            int dot = tagName.lastIndexOf(".");
            tagName = tagName.substring(0, dot);
        }
        return tagName;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    protected Long userCheckInterval() {
        return null;
    }

    @Override
    public boolean isValid() {
        return null != this.file && this.file.canRead();
    }

    @Override
    protected String reload() {
        return IO.readContentAsString(this.file);
    }

    @Override
    public String getSuggestedClassName() {
        return FileTemplateResource.path2CN(this.key);
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    public static String getFullTagName(TemplateClass tc, RythmEngine engine) {
        int pos;
        if (null == engine) {
            engine = Rythm.engine();
        }
        String key = tc.getKey().toString();
        File home = engine.conf().templateHome();
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (null != home && key.startsWith(home.getPath())) {
            key = key.replace(home.getPath(), "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (-1 != (pos = key.lastIndexOf("."))) {
            key = key.substring(0, pos);
        }
        key = key.replace('/', '.').replace('\\', '.');
        key = key + tc.codeType.resourceNameSuffix();
        return key;
    }

    public static TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerClass) {
        return FileTemplateResource.tryLoadTemplate(tmplName, engine, callerClass, true);
    }

    private static TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerClass, boolean processTagName) {
        if (null == engine) {
            engine = Rythm.engine();
        }
        if (engine.templateRegistered(tmplName)) {
            return null;
        }
        String rythmSuffix = engine.conf().resourceNameSuffix();
        ArrayList<String> suffixes = new ArrayList<String>(Arrays.asList(".html", ".json", ".js", ".css", ".csv", ".xml", ".txt", ""));
        ICodeType codeType = TemplateResourceBase.getTypeOfPath(engine, tmplName);
        if (ICodeType.DefImpl.RAW == codeType) {
            codeType = callerClass.codeType;
        }
        String tagNameOrigin = tmplName;
        if (processTagName) {
            boolean tagNameProcessed = false;
            while (!tagNameProcessed) {
                for (String s : suffixes) {
                    if (!tmplName.endsWith(s)) continue;
                    tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                    break;
                }
                if (S.notEmpty(rythmSuffix)) {
                    for (String s : suffixes) {
                        if (!tmplName.endsWith(s = s + rythmSuffix)) continue;
                        tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                        break;
                    }
                }
                tagNameProcessed = true;
            }
        }
        tmplName = tmplName.replace('.', '/');
        String sfx = codeType.resourceNameSuffix();
        if (S.notEmpty(sfx) && !((String)suffixes.get(0)).equals(sfx)) {
            suffixes.remove(sfx);
            suffixes.add(0, sfx);
        }
        ArrayList<String> roots = new ArrayList<String>();
        File home = engine.conf().templateHome();
        String root = home.getPath();
        if (null != callerClass.importPaths) {
            for (String s : callerClass.importPaths) {
                roots.add(root + File.separator + s.replace('.', File.separatorChar));
            }
        }
        String tagName0 = tmplName;
        String currentPath = callerClass.getKey().toString();
        int pos = currentPath.lastIndexOf("/");
        if (-1 == pos) {
            pos = currentPath.lastIndexOf(File.separator);
        }
        if (-1 != pos) {
            if ((currentPath = currentPath.substring(0, pos)).startsWith("/") || currentPath.startsWith(File.separator)) {
                currentPath = currentPath.substring(1);
            }
            if (!currentPath.startsWith(root)) {
                currentPath = root + File.separator + currentPath;
            }
            roots.add(currentPath);
        }
        roots.add(root);
        for (String r : roots) {
            tmplName = r + File.separator + tagName0;
            for (String suffix : suffixes) {
                String name = tmplName + suffix + rythmSuffix;
                File tagFile = new File(name);
                TemplateResourceBase tr = tagFile.canRead() && !tagFile.isDirectory() ? new FileTemplateResource(tagFile, engine) : new ClasspathTemplateResource(name, engine);
                if (!tr.isValid()) continue;
                try {
                    TemplateClass tc = engine.classes().getByTemplate(tr.getKey());
                    if (null == tc) {
                        tc = new TemplateClass(tr, engine);
                    }
                    try {
                        tc.asTemplate();
                        return tc;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return tc;
                    }
                }
                catch (Exception e) {
                }
            }
        }
        return processTagName ? FileTemplateResource.tryLoadTemplate(tagNameOrigin, engine, callerClass, false) : null;
    }
}

