/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.utils.IO;

public class ClasspathTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private URL url;
    private String key;

    public ClasspathTemplateResource(String path) {
        this(path, null);
    }

    public ClasspathTemplateResource(String path, RythmEngine engine) {
        super(engine);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = Rythm.class.getClassLoader();
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.url = cl.getResource(path);
        this.key = path;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String reload() {
        return IO.readContentAsString(this.url);
    }

    @Override
    protected long lastModified() {
        String fileName;
        if (this.engine().isProdMode()) {
            return 0L;
        }
        if ("file".equals(this.url.getProtocol())) {
            fileName = this.url.getFile();
        } else if ("jar".equals(this.url.getProtocol())) {
            try {
                JarURLConnection jarUrl = (JarURLConnection)this.url.openConnection();
                fileName = jarUrl.getJarFile().getName();
            }
            catch (Exception e) {
                return System.currentTimeMillis() + 1L;
            }
        } else {
            return System.currentTimeMillis() + 1L;
        }
        File file = new File(fileName);
        return file.lastModified();
    }

    @Override
    public boolean isValid() {
        return null != this.url;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClasspathTemplateResource) {
            ClasspathTemplateResource that = (ClasspathTemplateResource)obj;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    @Override
    protected long defCheckInterval() {
        return -1L;
    }

    @Override
    protected Long userCheckInterval() {
        return 5000L;
    }

    @Override
    public String getSuggestedClassName() {
        return ClasspathTemplateResource.path2CN(this.key);
    }
}

