/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class VerbatimParser
extends KeywordParserFactory {
    private static final String R = "(^\\n?[ \\t\\x0B\\f]*%s%s\\s*(\\(\\s*\\))?\\s*((?@{})))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = VerbatimParser.this.reg(this.dialect());
                if (r.search(this.remain())) {
                    String matched = r.stringMatched();
                    this.step(matched.length());
                    String s0 = r.stringMatched(3);
                    s0 = S.strip(s0, "{", "}");
                    String s = s0 = S.strip(s0, "\n", "\n");
                    return new Token(s, this.ctx(), true){

                        @Override
                        protected void output() {
                            this.s = this.compact(this.s);
                            this.s = this.s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"");
                            this.p("p(org.rythmengine.utils.S.escape(\"").p(this.s).p("\"));");
                            this.pline();
                        }
                    };
                }
                return null;
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.VERBATIM;
    }
}

