/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.regex.Matcher;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.Patterns;
import org.rythmengine.internal.parser.build_in.InvokeTemplateParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class RenderSectionParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RENDER_SECTION;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String code;
                String blank;
                Regex r0;
                Matcher m = RenderSectionParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String matched = m.group(1);
                boolean lineBreak = false;
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    lineBreak = matched.endsWith("\n");
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String section = m.group(4);
                String s = this.remain();
                Matcher m0 = InvokeTemplateParser.P_HEREDOC_SIMBOL.matcher(s);
                Matcher m1 = InvokeTemplateParser.P_STANDARD_BLOCK.matcher(s);
                if (m0.matches()) {
                    this.ctx().step(m0.group(1).length());
                    return new DefaultSectionToken(section, this.ctx());
                }
                if (m1.matches()) {
                    this.ctx().step(m1.group(1).length());
                    return new DefaultSectionToken(section, this.ctx());
                }
                boolean isSection = S.notEmpty(section);
                if (matched.startsWith("\n") && !isSection) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                }
                String string = code = !isSection ? "__pLayoutContent();" : "__pLayoutSection(\"" + section + "\");";
                if (lineBreak && isSection) {
                    code = code + ";\npn();\n";
                }
                return new CodeToken(code, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(^\\n?[ \\t\\x0B\\f]*%s%s\\s*[\\s\\(]\"?'?(" + (Object)((Object)Patterns.VarName) + ")?\"?'?\\)?).*";
    }

    public class DefaultSectionToken
    extends BlockCodeToken {
        private String section;

        public DefaultSectionToken(String section, IContext context) {
            super(null, context);
            if (S.isEmpty(section)) {
                this.section = "__CONTENT__";
            }
            this.section = section;
        }

        @Override
        public void output() {
            this.p2t("__startSection(\"").p(this.section).p("\");");
            this.pline();
        }

        @Override
        public String closeBlock() {
            StringBuilder sbNew = new StringBuilder();
            StringBuilder sbOld = this.__getBuffer();
            this.__setBuffer(sbNew);
            this.p2tline("__endSection(true);", new Object[0]);
            if ("__CONTENT__".equals(this.section)) {
                this.p2tline("__pLayoutContent();", new Object[0]);
            } else {
                this.p2t("__pLayoutSection(\"").p(this.section).p("\");");
                this.pline();
            }
            this.__setBuffer(sbOld);
            return sbNew.toString();
        }
    }
}

