/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.parser.Directive;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.TextBuilder;

public class LogTimeParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.LOG_TIME;
    }

    @Override
    public IParser create(IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public TextBuilder go() {
                Regex r = LogTimeParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("error parsing @__logTime__, correct usage: @__logTime__()", new Object[0]);
                }
                this.step(r.stringMatched().length());
                return new Directive("", this.ctx()){

                    @Override
                    public void call() {
                        this.ctx().getCodeBuilder().setLogTime();
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*\\(\\s*\\)[\\r\\n]+";
    }
}

