/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.Locale;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class LocaleParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.LOCALE;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String blank;
                Regex r0;
                Regex r = LocaleParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                String matched = r.stringMatched();
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String s = r.stringMatched(1);
                s = S.stripBrace(s);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @locale statement. locale parameter expected", new Object[0]);
                }
                String code = s;
                Locale locale = (Locale)ctx.getEngine().eval(String.format("org.rythmengine.utils.Eval.locale(%s)", code));
                ctx.pushLocale(locale);
                s = String.format("__ctx.pushLocale(org.rythmengine.utils.Eval.locale(%s));", s);
                return new BlockCodeToken(s, this.ctx()){

                    @Override
                    public void openBlock() {
                    }

                    @Override
                    public String closeBlock() {
                        this.ctx.popLocale();
                        return "__ctx.popLocale();";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))[\\s]*\\{?[ \\t\\x0B\\f]*\\n?";
    }
}

