/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.Directive;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.TextBuilder;

public class InitCodeParser
extends KeywordParserFactory {
    private static final String R = "(\\n?[ \\t\\x0B\\f]*%s%s\\s*(\\(\\s*\\))?\\s*((?@{}))?[ \\t\\x0B\\f]*\\n?)";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public TextBuilder go() {
                Regex r = InitCodeParser.this.reg(this.dialect());
                if (r.search(this.remain())) {
                    String blank;
                    Regex r0;
                    String matched = r.stringMatched();
                    if (matched.startsWith("\n") || matched.endsWith("\n")) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                        r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                        if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                            ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                        }
                    } else {
                        r0 = new Regex("([ \\t\\x0B\\f]*).*");
                        if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                            ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                        }
                    }
                    this.step(matched.length());
                    String s0 = r.stringMatched(3);
                    s0 = s0.substring(1);
                    String s = s0 = s0.substring(0, s0.length() - 1);
                    return new Directive(s, ctx){

                        @Override
                        public void call() {
                            this.ctx.getCodeBuilder().setInitCode(this.s);
                        }
                    };
                }
                this.raiseParseException("Invalid @init syntax found. Correct usage: @init{/*your code come here*/}", new Object[0]);
                return null;
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.INIT;
    }
}

