/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.regex.Matcher;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class ImportParser
extends KeywordParserFactory {
    private static final String R = "(\\n?[ \\t\\x0B\\f]*%s%s[\\s]+([a-zA-Z0-9_\\.*,[ \\t\\x0B\\f]*)]+);?\\n?).*";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String blank;
                String line;
                String matched;
                String remain = this.remain();
                Regex r = new Regex(String.format("\\n?[ \\t\\x0B\\f]*%s%s(\\([ \t\f]*\\))?[ \t\f]*((?@{}))[ \\t\\x0B\\f]*\\n?", this.a(), ImportParser.this.keyword()));
                if (r.search(remain)) {
                    matched = r.stringMatched();
                    String s = r.stringMatched(2);
                    s = S.strip(s, "{", "}");
                    this.step(matched.length());
                    line = s.replaceAll("[\\n\\r]+", ",");
                } else {
                    Matcher m = ImportParser.this.ptn(this.dialect()).matcher(remain);
                    if (!m.matches()) {
                        return null;
                    }
                    String s = m.group(1);
                    this.step(s.length());
                    matched = s;
                    line = m.group(2);
                }
                this.checkRestrictedClass(line);
                String[] sa = line.split("[;, \\t\\x0B\\f]+");
                CodeBuilder cb = this.builder();
                boolean statik = false;
                for (String imp : sa) {
                    if (S.isEmpty(imp)) continue;
                    if ("static".equals(imp)) {
                        statik = true;
                        continue;
                    }
                    cb.addImport(statik ? "static " + imp : imp, this.ctx().currentLine() - 1);
                    statik = false;
                }
                boolean leadingLB = matched.startsWith("\n");
                boolean afterLB = matched.endsWith("\n");
                if (leadingLB) {
                    Regex r0;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    if (leadingLB ^ afterLB && (r0 = new Regex("\\n([ \\t\\x0B\\f]*).*")).search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    Regex r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                return Token.EMPTY_TOKEN;
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.IMPORT;
    }
}

