/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.RemoveLeadingSpacesIfLineBreakParser;
import org.rythmengine.internal.parser.build_in.ExpressionParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.TextBuilder;

public class IfParser
extends KeywordParserFactory {
    @Override
    public IParser create(final IContext ctx) {
        return new RemoveLeadingSpacesIfLineBreakParser(ctx){

            @Override
            public TextBuilder go() {
                String blank;
                Regex r0;
                boolean leadingLB;
                Regex r = IfParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @if statement. Correct usage: @if (some-condition) {some-template-code}", new Object[0]);
                }
                String matched = r.stringMatched();
                int line = ctx.currentLine();
                boolean bl = leadingLB = !this.isLastBuilderLiteral();
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    if (matched.startsWith("\n")) {
                        leadingLB = true;
                        ++line;
                    }
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    if (!matched.startsWith("\n") && (r0 = new Regex("\\n([ \\t\\x0B\\f]*).*")).search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                String s = r.stringMatched(1);
                this.ctx().step(s.length());
                String sIf = r.stringMatched(3);
                s = r.stringMatched(4);
                s = ExpressionParser.processPositionPlaceHolder(s);
                s = "if".equalsIgnoreCase(sIf) ? "\nif (org.rythmengine.utils.Eval.eval(" + s + ")) {" : "\nif (!org.rythmengine.utils.Eval.eval(" + s + ")) {";
                this.processFollowingOpenBraceAndLineBreak(leadingLB);
                return new IfBlockCodeToken(s, this.ctx(), line);
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.IF;
    }

    @Override
    protected String patternStr() {
        return "(^\\n?[ \\t\\x0B\\f]*%s(%s\\s*((?@()))([ \\t\\x0B\\f]*\\n?))).*";
    }

    public static class IfBlockCodeToken
    extends BlockCodeToken {
        public IfBlockCodeToken(String s, IContext context, int line) {
            super(s, context);
            this.line = line;
        }
    }
}

