/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.Arrays;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.Escape;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class EscapeParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.ESCAPE;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r0;
                Regex r = EscapeParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                String matched = r.stringMatched();
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    String blank;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    String blank;
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                s = S.isEmpty(s) ? "HTML" : ("JavaScript".equalsIgnoreCase(s) ? "JS" : s.toUpperCase());
                if (Arrays.binarySearch(Escape.stringValues(), s) < 0) {
                    this.raiseParseException("Error parsing @escape statement. Escape parameter expected to be one of %s, found: %s", Arrays.asList(Escape.stringValues()), s);
                }
                s = String.format("__ctx.pushEscape(org.rythmengine.utils.Escape.%s);", s);
                return new BlockCodeToken(s, this.ctx()){

                    @Override
                    public void openBlock() {
                    }

                    @Override
                    public String closeBlock() {
                        return "__ctx.popEscape();";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))[\\s]*\\{?[ \\t\\x0B\\f]*\\n?";
    }
}

