/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class DirectiveCommentEndSensor
extends RemoveLeadingLineBreakAndSpacesParser {
    ILogger logger = Logger.get(DirectiveCommentEndSensor.class);
    private static Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public DirectiveCommentEndSensor(IContext context) {
        super(context);
    }

    @Override
    public TextBuilder go() {
        IContext ctx = this.ctx();
        if (!ctx.insideDirectiveComment()) {
            return null;
        }
        for (ICodeType type = ctx.peekCodeType(); null != type; type = type.getParent()) {
            Matcher m;
            String s = type.commentEnd();
            if (S.empty(s)) continue;
            s = S.escapeRegex(s).toString();
            s = "(\\s*" + s + ")" + ".*";
            Pattern p = patterns.get(s);
            if (null == p) {
                p = Pattern.compile(s, 32);
                patterns.put(s, p);
            }
            if (!(m = p.matcher(this.remain())).matches()) continue;
            s = m.group(1);
            ctx.step(s.length());
            ctx.leaveDirectiveComment();
            return Token.EMPTY_TOKEN;
        }
        return null;
    }
}

