/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.CaretParserFactoryBase;
import org.rythmengine.utils.TextBuilder;

public class CommentParser
extends CaretParserFactoryBase {
    @Override
    public IParser create(final IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public TextBuilder go() {
                Pattern p = this.inlineComment();
                Matcher m = p.matcher(this.remain());
                if (!m.matches()) {
                    p = this.blockComment();
                    m = p.matcher(this.remain());
                    if (!m.matches()) {
                        return null;
                    }
                } else if (ctx.insideDirectiveComment()) {
                    ctx.leaveDirectiveComment();
                }
                String s = m.group(1);
                ctx.step(s.length());
                return Token.EMPTY_TOKEN;
            }

            private Pattern inlineComment() {
                return Pattern.compile(String.format("^(%s/.*?)(\n.*|$)", this.a()), 32);
            }

            private Pattern blockComment() {
                return Pattern.compile(String.format("^(%s\\*.*?\\*%s).*", this.a(), this.a()), 32);
            }
        };
    }
}

