/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.Rythm;
import org.rythmengine.Sandbox;
import org.rythmengine.exception.ParseException;
import org.rythmengine.internal.ICaretParserFactory;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IParserFactory;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;

public abstract class CaretParserFactoryBase
implements ICaretParserFactory {
    protected ILogger logger = Logger.get(IParserFactory.class);

    @Override
    public String getCaret(IDialect dialect) {
        return dialect.a();
    }

    public static void raiseParseException(IContext ctx, String msg, Object ... args) {
        throw new ParseException(ctx.getEngine(), ctx.getTemplateClass(), ctx.currentLine(), msg, args);
    }

    public static void checkRestrictedClass(IContext ctx, String s) {
        String s0;
        if (Rythm.insideSandbox() && null != (s0 = Sandbox.hasAccessToRestrictedClasses(ctx.getEngine(), s))) {
            CaretParserFactoryBase.raiseParseException(ctx, "Access to restricted class [%s] is blocked in sandbox mode", s0);
        }
    }

    public static void p(int i, Regex r) {
        if (0 == i) {
            System.out.println(i + ": " + r.stringMatched());
        } else {
            System.out.println(i + ": " + r.stringMatched(i));
        }
    }

    public static void p(String s, Regex r) {
        if (r.search(s)) {
            CaretParserFactoryBase.p(r);
        }
    }

    public static void p(String s, Regex r, int max) {
        if (r.search(s)) {
            CaretParserFactoryBase.p(r, max);
        }
    }

    public static void p(Regex r, int max) {
        for (int i = 0; i < max; ++i) {
            CaretParserFactoryBase.p(i, r);
        }
    }

    public static void p(Regex r) {
        CaretParserFactoryBase.p(r, 6);
    }
}

