/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.TextBuilder;

public class BreakParser
extends KeywordParserFactory {
    private static final String R = "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*(\\(\\s*\\))?[\\s;]*)";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new RemoveLeadingLineBreakAndSpacesParser(c){

            @Override
            public TextBuilder go() {
                Regex r = BreakParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Bad @break statement. Correct usage: @break()", new Object[0]);
                }
                String matched = r.stringMatched();
                this.step(matched.length());
                IContext.Break b = this.ctx().peekBreak();
                if (null == b) {
                    this.raiseParseException("Bad @break statement: No loop context", new Object[0]);
                }
                return new CodeToken(b.getStatement(), this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.BREAK;
    }
}

