/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IBlockHandler;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.IParserFactory;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.BlockToken;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class BraceParser
implements IParserFactory {
    private final Pattern P = Pattern.compile("^((\\n[ \\t\\x0B\\f]*}[ \\t\\x0B\\f]*)\\n).*", 32);

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Matcher m;
                boolean isLiteral;
                String remain = this.remain();
                char c = remain.charAt(0);
                if ('{' == c) {
                    this.step(1);
                    return new BlockToken.LiteralBlock(this.ctx());
                }
                IBlockHandler bh = this.ctx().currentBlock();
                boolean bl = isLiteral = null == bh ? false : bh instanceof BlockToken.LiteralBlock;
                if ('}' == c) {
                    this.step(1);
                    if (null == bh) {
                        this.raiseParseException("no open block found", new Object[0]);
                    }
                    String s = this.ctx().closeBlock();
                    if (isLiteral) {
                        if ("".equals(s)) {
                            return Token.EMPTY_TOKEN;
                        }
                        return new Token.StringToken(s, this.ctx());
                    }
                    CodeToken ct = new CodeToken(s, this.ctx());
                    String bhCls = bh.getClass().getName();
                    if (bhCls.contains("For")) {
                        ctx.getCodeBuilder().removeSpaceTillLastLineBreak(ctx);
                        ct.removeNextLineBreak = true;
                    } else if (bhCls.contains("Assign")) {
                        remain = ctx.getRemain();
                        Matcher m2 = Pattern.compile("(^[ \\t\\x0B\\f]*\\n).*", 32).matcher(remain);
                        if (m2.matches()) {
                            String space = m2.group(1);
                            this.step(space.length());
                        }
                    } else {
                        ctx.getCodeBuilder().removeSpaceToLastLineBreak(ctx);
                    }
                    if (S.isEmpty(s)) {
                        return Token.EMPTY_TOKEN;
                    }
                    return ct;
                }
                if (null != bh && !isLiteral && (m = BraceParser.this.P.matcher(remain)).matches()) {
                    CodeBuilder cb = ctx.getCodeBuilder();
                    String bhCls = bh.getClass().getName();
                    String s = m.group(2);
                    if (bhCls.contains("For")) {
                        cb.addBuilder(new Token.StringToken("\n", ctx));
                        cb.removeNextLF = true;
                    } else if ((bhCls.contains("Assign") || bhCls.contains("DefTag")) && m.group(1).endsWith("\n")) {
                        cb.removeNextLF = true;
                    }
                    ctx.step(s.length());
                    CodeToken ct = new CodeToken(ctx.closeBlock(), ctx);
                    return ct;
                }
                return null;
            }
        };
    }
}

