/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.exception.ParseException;
import org.rythmengine.internal.IBlockHandler;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.BlockToken;

public class BlockCloseParser
extends ParserBase {
    private static final String PTN = "([\\}]?%s[\\}\\s\\n\\>\\]]).*";
    private static final String PTN2 = "((\\}%s|%s\\}|\\})([ \\t\\x0B\\f]*\\{?[ \\t\\x0B\\f]*\\n?)).*";

    public BlockCloseParser(IContext context) {
        super(context);
    }

    @Override
    public Token go() {
        String s;
        IContext ctx = this.ctx();
        IBlockHandler bh = ctx.currentBlock();
        if (null == bh) {
            return null;
        }
        String remain = this.remain();
        if ("@".equals(remain)) {
            s = remain;
        } else {
            Pattern p = Pattern.compile(String.format(PTN2, this.a(), this.a(), this.a()), 32);
            Matcher m = p.matcher(remain);
            if (!m.matches() && !(m = (p = Pattern.compile(String.format(PTN, this.a()), 32)).matcher(remain)).matches()) {
                return null;
            }
            s = m.group(1);
        }
        if (s.endsWith(">") || s.endsWith("]") || s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        ctx.step(s.length());
        boolean hasLineBreak = s.contains("\\n") || s.contains("\\r");
        try {
            s = ctx.closeBlock();
            if (hasLineBreak) {
                s = s + "\n";
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        CodeToken ct = new CodeToken(s, ctx);
        if (!(bh instanceof BlockToken.LiteralBlock)) {
            String bhCls = bh.getClass().getName();
            if (bhCls.contains("ForEach") || bhCls.contains("ElseFor") || bhCls.contains("Assign")) {
                ctx.getCodeBuilder().removeSpaceTillLastLineBreak(ctx);
                ct.removeNextLineBreak = true;
            } else {
                ctx.getCodeBuilder().removeSpaceToLastLineBreak(ctx);
            }
        }
        return ct;
    }
}

