/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.Patterns;
import org.rythmengine.internal.parser.build_in.CaretParserFactoryBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class AssignParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.ASSIGN;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = AssignParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @assign statement. Correct usage: @assign(myVariable){...}", new Object[0]);
                }
                String matched = r.stringMatched();
                this.step(matched.length());
                String s = r.stringMatched(1);
                s = S.stripBrace(s);
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    String blank;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    Regex r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    String blank;
                    Regex r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                return new AssignToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "\\n?[ \\t\\x0B\\f]*%s%s[ \\t\\x0B\\f]*((?@()))[ \\t\\x0B\\f]*\\{?[ \\t\\x0B\\f]*\\n?";
    }

    public class AssignToken
    extends BlockCodeToken {
        private String assignTo;
        private boolean isFinal;

        public AssignToken(String assignTo, IContext context) {
            super(null, context);
            String[] sa = assignTo.split(",");
            this.assignTo = S.stripQuotation(sa[0]);
            if (Patterns.RESERVED.matches(this.assignTo)) {
                CaretParserFactoryBase.raiseParseException(this.ctx, "assign variable name is reserved: %s", this.assignTo);
            }
            if (sa.length > 1) {
                this.isFinal = Boolean.parseBoolean(sa[1].trim());
            }
        }

        @Override
        public void output() {
            String assignTo = this.assignTo;
            if (this.isFinal) {
                assignTo = this.assignTo + "___";
            }
            this.p2t("Object ").p(assignTo).p(" = null;");
            this.p2tline("{", new Object[0]);
            this.p3tline("StringBuilder sbOld = getSelfOut();", new Object[0]);
            this.p3tline("StringBuilder sbNew = new StringBuilder();", new Object[0]);
            this.p3tline("setSelfOut(sbNew);", new Object[0]);
        }

        @Override
        public String closeBlock() {
            String assignTo = this.assignTo;
            if (this.isFinal) {
                assignTo = this.assignTo + "___";
            }
            StringBuilder sbNew = new StringBuilder();
            StringBuilder sbOld = this.__getBuffer();
            this.__setBuffer(sbNew);
            String varName = this.ctx.getCodeBuilder().newVarName();
            this.p3tline(String.format("String %s = sbNew.toString();", varName), new Object[0]);
            this.p3tline("setSelfOut(sbOld);", new Object[0]);
            this.p3t(assignTo).p(String.format(" = %s;", varName));
            this.pline();
            this.p2tline("}", new Object[0]);
            if (this.isFinal) {
                this.p2t("final Object ").p(this.assignTo).p(" = ").p(assignTo).p(";");
                this.pline();
            }
            String s = sbNew.toString();
            this.__setBuffer(sbOld);
            return s;
        }
    }
}

