/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.dialect;

import java.util.Stack;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IParserFactory;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.dialect.Rythm;
import org.rythmengine.internal.dialect.SimpleRythm;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.S;

public class DialectManager {
    protected ILogger logger = Logger.get(DialectManager.class);
    static final IDialect[] defDialects = new IDialect[]{BasicRythm.INSTANCE, SimpleRythm.INSTANCE, Rythm.INSTANCE};
    private static final InheritableThreadLocal<Stack<IDialect>> cur = new InheritableThreadLocal<Stack<IDialect>>(){

        @Override
        protected Stack<IDialect> initialValue() {
            return new Stack<IDialect>();
        }
    };

    public static IDialect getById(String id) {
        for (IDialect d : defDialects) {
            if (!S.isEqual(id, d.id())) continue;
            return d;
        }
        return null;
    }

    private static int indexOf(IDialect dialect) {
        if (null == dialect) {
            throw new NullPointerException();
        }
        for (int i = 0; i < defDialects.length; ++i) {
            if (!S.isEqual(dialect.id(), defDialects[i].id())) continue;
            return i;
        }
        return -1;
    }

    private static IDialect nextAvailable(IDialect d) {
        if (null == d) {
            return defDialects[0];
        }
        int i = DialectManager.indexOf(d) + 1;
        if (i >= defDialects.length) {
            return null;
        }
        return defDialects[i];
    }

    public static void push(IDialect dialect) {
        if (null == dialect) {
            throw new NullPointerException();
        }
        ((Stack)cur.get()).push(dialect);
    }

    public static IDialect current() {
        return (IDialect)((Stack)cur.get()).peek();
    }

    public static IDialect pop() {
        return (IDialect)((Stack)cur.get()).pop();
    }

    public void beginParse(IContext ctx) {
        CodeBuilder cb = ctx.getCodeBuilder();
        IDialect d = cb.requiredDialect;
        if (null == d) {
            d = ctx.getDialect();
            if (null != d) {
                if (null == (d = DialectManager.nextAvailable(d))) {
                    throw new NullPointerException("No dialect can process the template");
                }
            } else {
                String template = ctx.getRemain();
                for (IDialect d0 : defDialects) {
                    if (!d0.isMyTemplate(template)) continue;
                    d = d0;
                    break;
                }
            }
        }
        ctx.setDialect(d);
        DialectManager.push(d);
        d.begin(ctx);
    }

    public void endParse(IContext ctx) {
        IDialect d = ctx.getDialect();
        d.end(ctx);
        DialectManager.pop();
    }

    private void registerParserFactories(IDialect dialect, IParserFactory ... factories) {
        for (IParserFactory pf : factories) {
            dialect.registerParserFactory(pf);
        }
    }

    public void registerExternalParsers(String dialectId, IParserFactory ... factories) {
        if (null == dialectId) {
            for (IDialect d : defDialects) {
                this.registerParserFactories(d, factories);
            }
        } else {
            IDialect d = DialectManager.getById(dialectId);
            if (null != d) {
                this.registerParserFactories(d, factories);
            } else {
                throw new IllegalArgumentException("Cannot find dialect by Id: " + dialectId);
            }
        }
    }
}

