/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.HashSet;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.TextBuilder;

public class TemplateClassCache {
    private static final ILogger logger = Logger.get(TemplateClassCache.class);
    private final RythmEngine engine;
    private final RythmConfiguration conf;
    private final Rythm.Mode mode;

    public TemplateClassCache(RythmEngine engine) {
        if (null == engine) {
            throw new NullPointerException();
        }
        this.engine = engine;
        this.conf = engine.conf();
        this.mode = engine.mode();
    }

    private boolean enabled() {
        return (this.mode.isDev() || this.conf.loadPrecompiled() || this.conf.precompileMode()) && !RythmEngine.insideSandbox();
    }

    public void deleteCache(TemplateClass tc) {
        try {
            File f = this.getCacheFile(tc);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadTemplateClass(TemplateClass tc) {
        if (!this.enabled()) {
            return;
        }
        try {
            String curHash;
            File f = this.getCacheFile(tc);
            if (!f.exists() || !f.canRead()) {
                return;
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            int offset = 0;
            int read = -1;
            StringBuilder hash = new StringBuilder();
            while ((read = ((InputStream)is).read()) != 0) {
                if (read == -1) {
                    logger.error("Failed to read cache file for template class: %s", tc);
                    return;
                }
                hash.append((char)read);
                ++offset;
            }
            if (!this.conf.loadPrecompiled() && !(curHash = this.hash(tc)).equals(hash.toString())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Bytecode too old (%s != %s)", hash, curHash);
                }
                return;
            }
            read = -1;
            StringBuilder source = new StringBuilder();
            while ((read = ((InputStream)is).read()) != 0) {
                source.append((char)read);
                ++offset;
            }
            if (source.length() != 0) {
                String s = source.toString();
                String[] sa = s.split("__INCLUDED_TAG_TYPES__");
                tc.javaSource = sa[0];
                s = sa[1];
                sa = s.split("__INCULDED_TEMPLATE_CLASS_NAME_LIST__");
                tc.deserializeIncludeTagTypes(sa[0]);
                s = sa[1];
                sa = s.split("__IMPORT_PATH_LIST__");
                tc.includeTemplateClassNames = sa[0];
                s = sa[1];
                sa = s.split(";");
                tc.importPaths = new HashSet<String>();
                for (String path : sa) {
                    if ("java.lang".equals(path)) continue;
                    tc.importPaths.add(path);
                }
            }
            byte[] byteCode = new byte[(int)f.length() - (offset + 2)];
            ((InputStream)is).read(byteCode);
            tc.loadCachedByteCode(byteCode);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheTemplateClassSource(TemplateClass tc) {
        if (!this.enabled()) {
            return;
        }
        try {
            File f = this.getCacheSourceFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(tc.javaSource.getBytes("utf-8"));
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheTemplateClass(TemplateClass tc) {
        if (!this.enabled()) {
            return;
        }
        String hash = this.hash(tc);
        try {
            File f = this.getCacheFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(hash.getBytes("utf-8"));
            ((OutputStream)os).write(0);
            if (null != tc.javaSource) {
                TextBuilder tb = new TextBuilder();
                tb.p(tc.javaSource);
                tb.p("__INCLUDED_TAG_TYPES__").p(tc.serializeIncludeTagTypes());
                tb.p("__INCULDED_TEMPLATE_CLASS_NAME_LIST__").p(tc.refreshIncludeTemplateClassNames()).p("__IMPORT_PATH_LIST__");
                if (tc.importPaths == null) {
                    tc.importPaths = new HashSet<String>(0);
                }
                if (tc.importPaths.isEmpty()) {
                    tc.importPaths.add("java.lang");
                }
                boolean first = true;
                for (String s : tc.importPaths) {
                    if (!first) {
                        tb.p(";");
                    } else {
                        first = false;
                    }
                    tb.p(s);
                }
                ((OutputStream)os).write(tb.toString().getBytes("utf-8"));
            }
            ((OutputStream)os).write(0);
            ((OutputStream)os).write(tc.enhancedByteCode);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String hash(TemplateClass tc) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update((this.engine.version() + tc.getTemplateSource(true)).getBytes("utf-8"));
            byte[] digest = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int value = digest[i];
                if (value < 0) {
                    value += 256;
                }
                builder.append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String cacheFileName(TemplateClass tc, String suffix) {
        return tc.name0() + suffix;
    }

    private File getCacheFile(String fileName) {
        RythmConfiguration conf = this.engine.conf();
        if (conf.loadPrecompiled() || conf.precompileMode()) {
            File precompileDir = (File)conf.get(RythmConfigurationKey.HOME_PRECOMPILED);
            return new File(precompileDir, fileName);
        }
        File f = new File(conf.tmpDir(), fileName);
        return f;
    }

    File getCacheFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".rythm");
        return this.getCacheFile(id);
    }

    File getCacheSourceFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".java");
        return this.getCacheFile(id);
    }
}

