/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.exception.CompileException;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.IByteCodeEnhancer;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.TagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.S;

public class TemplateClass {
    private static final ILogger logger = Logger.get(TemplateClass.class);
    private TemplateClass root;
    private boolean inner = false;
    private RythmEngine engine = null;
    private String name;
    public TemplateClass extendedTemplateClass;
    private Set<TemplateClass> includedTemplateClasses = new HashSet<TemplateClass>();
    public String includeTemplateClassNames = null;
    private static final String NO_INCLUDE_CLASS = "NO_INCLUDE_CLASS";
    private Map<String, String> includeTagTypes = new HashMap<String, String>();
    private transient String fullName;
    public ITemplateResource templateResource;
    public String javaSource;
    public byte[] javaByteCode;
    public byte[] enhancedByteCode;
    public Set<String> importPaths;
    public Class<ITemplate> javaClass;
    public Package javaPackage;
    public ICodeType codeType;
    boolean compiled;
    public int sigChecksum;
    public boolean isValid = true;
    public CodeBuilder codeBuilder;
    private TemplateBase templateInstance;
    private transient IDialect dialect;
    private static final ITemplate NULL_TEMPLATE = new TagBase(){

        @Override
        public ITemplate __cloneMe(RythmEngine engine, ITemplate caller) {
            return null;
        }
    };
    private boolean refreshing = false;
    private boolean compiling = false;
    private Object refreshLock = new Object();
    private RefreshLock lock;
    public static final String CN_SUFFIX = "__R_T_C__";
    private boolean enhancing = false;
    private transient List<TemplateClass> embeddedClasses = new ArrayList<TemplateClass>();

    public TemplateClass root() {
        return this.root;
    }

    private TemplateClass() {
    }

    public static TemplateClass createInnerClass(String className, byte[] byteCode, TemplateClass parent) {
        TemplateClass tc = new TemplateClass();
        tc.name = className;
        tc.javaByteCode = byteCode;
        tc.inner = true;
        tc.root = parent.root();
        return tc;
    }

    public boolean isInner() {
        return this.inner;
    }

    private RythmEngine engine() {
        return null == this.engine ? Rythm.engine() : this.engine;
    }

    public String name0() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public void addIncludeTemplateClass(TemplateClass tc) {
        this.includedTemplateClasses.add(tc);
        this.includeTagTypes.putAll(tc.includeTagTypes);
    }

    public String refreshIncludeTemplateClassNames() {
        if (this.includedTemplateClasses.size() == 0) {
            this.includeTemplateClassNames = NO_INCLUDE_CLASS;
            return NO_INCLUDE_CLASS;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TemplateClass tc : this.includedTemplateClasses) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.engine().resourceManager().getFullTagName(tc));
        }
        this.includeTemplateClassNames = sb.toString();
        return sb.toString();
    }

    public void setTagType(String tagName, String type) {
        this.includeTagTypes.put(tagName, type);
    }

    public boolean returnObject(String tagName) {
        String retType = this.includeTagTypes.get(tagName);
        if (null != retType) {
            return !"void".equals(retType);
        }
        if (null != this.extendedTemplateClass) {
            return this.extendedTemplateClass.returnObject(tagName);
        }
        return true;
    }

    public String serializeIncludeTagTypes() {
        if (this.includeTagTypes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        for (String tagName : this.includeTagTypes.keySet()) {
            if (!empty) {
                sb.append(";");
            } else {
                empty = false;
            }
            sb.append(tagName).append(":").append(this.includeTagTypes.get(tagName));
        }
        return sb.toString();
    }

    public void deserializeIncludeTagTypes(String s) {
        String[] sa;
        this.includeTagTypes = new HashMap<String, String>();
        if (S.isEmpty(s)) {
            return;
        }
        for (String s0 : sa = s.split(";")) {
            String[] sa0 = s0.split(":");
            if (sa0.length != 2) {
                throw new IllegalArgumentException("Unknown include tag types string: " + s);
            }
            this.includeTagTypes.put(sa0[0], sa0[1]);
        }
    }

    public String tagName() {
        return null != this.templateResource ? this.templateResource.tagName() : null;
    }

    public void setFullName(String fn) {
        this.fullName = fn;
    }

    public String getFullName() {
        if (null == this.fullName) {
            return this.tagName();
        }
        return this.fullName;
    }

    public String getTemplateSource() {
        return this.getTemplateSource(false);
    }

    public String getTemplateSource(boolean includeRoot) {
        if (null != this.templateResource) {
            return this.templateResource.asTemplateContent();
        }
        if (!includeRoot) {
            return "";
        }
        TemplateClass parent = this.root;
        while (null != parent && parent.isInner()) {
            parent = parent.root;
        }
        return null == parent ? "" : parent.getTemplateSource();
    }

    public boolean isStringTemplate() {
        return this.templateResource instanceof StringTemplateResource;
    }

    private TemplateClass(RythmEngine engine) {
        this.engine = null == engine ? null : (engine.isSingleton() ? null : engine);
    }

    public TemplateClass(File file, RythmEngine engine) {
        this(engine.resourceManager().get(file), engine);
    }

    public TemplateClass(String template, RythmEngine engine) {
        this(engine.resourceManager().get(template), engine);
    }

    public TemplateClass(String template, RythmEngine engine, IDialect dialect) {
        this(engine.resourceManager().get(template), engine, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine) {
        this(resource, engine, false);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, IDialect dialect) {
        this(resource, engine, false, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        resource.setEngine(this.engine());
        this.templateResource = resource;
        if (!noRefresh) {
            this.refresh();
        }
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh, IDialect dialect) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        resource.setEngine(this.engine());
        this.templateResource = resource;
        this.dialect = dialect;
        if (!noRefresh) {
            this.refresh();
        }
    }

    public Object getKey() {
        return null == this.templateResource ? this.name() : this.templateResource.getKey();
    }

    private Class<?> getJavaClass() throws Exception {
        if (null == this.javaSource) {
            if (this.refreshing()) {
                this.lock.waitTillOpen();
            }
            if (null == this.javaSource) {
                this.refresh();
            }
        }
        Class<?> c = this.engine().classLoader().loadClass(this.name(), true);
        if (null == this.javaClass) {
            this.javaClass = c;
        }
        return c;
    }

    private ITemplate templateInstance_() {
        Class<?> c;
        Class<?> pc;
        if (!this.isValid) {
            return NULL_TEMPLATE;
        }
        if (null == this.templateInstance) {
            try {
                if (Logger.isTraceEnabled()) {
                    logger.trace("About to new template instance", new Object[0]);
                }
                Class<?> clz = this.getJavaClass();
                if (Logger.isTraceEnabled()) {
                    logger.trace("template java class loaded", new Object[0]);
                }
                this.templateInstance = (TemplateBase)clz.newInstance();
                this.templateInstance.__setTemplateClass(this);
                if (Logger.isTraceEnabled()) {
                    logger.trace("template instance generated", new Object[0]);
                }
            }
            catch (RythmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error load template instance for " + this.getKey(), e);
            }
        }
        RythmEngine engine = this.engine();
        engine.registerTemplate(this.templateInstance);
        if (!engine.isProdMode() && null != (pc = (c = this.templateInstance.getClass()).getSuperclass()) && !Modifier.isAbstract(pc.getModifiers())) {
            engine.classes().getByClassName(pc.getName());
        }
        return this.templateInstance;
    }

    public ITemplate asTemplate(ICodeType type, Locale locale) {
        RythmEngine e = this.engine();
        if (null == this.name || e.mode().isDev()) {
            this.refresh();
        }
        TemplateBase tmpl = (TemplateBase)this.templateInstance_().__cloneMe(this.engine(), null);
        tmpl.__prepareRender(type, locale);
        return tmpl;
    }

    public ITemplate asTemplate() {
        return this.asTemplate(null, null);
    }

    public ITemplate asTemplate(ITemplate caller) {
        TemplateBase tb = (TemplateBase)caller;
        TemplateBase tmpl = (TemplateBase)this.templateInstance_().__cloneMe(this.engine(), caller);
        tmpl.__prepareRender(tb.__curCodeType(), tb.__curLocale());
        return tmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshing() {
        Object object = this.refreshLock;
        synchronized (object) {
            return this.refreshing || this.compiling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshing(boolean b) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.refreshing = b;
        }
        if (b) {
            this.lock = new RefreshLock();
        } else {
            this.lock.close();
        }
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public void buildSourceCode(String includingClassName) {
        long start = System.currentTimeMillis();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = new CodeBuilder(this.templateResource.asTemplateContent(), this.name(), this.tagName(), this, this.engine, this.dialect);
        this.codeBuilder.includingCName = includingClassName;
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey());
        }
    }

    public void buildSourceCode() {
        long start = System.currentTimeMillis();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = null == this.dialect ? new CodeBuilder(this.templateResource.asTemplateContent(), this.name(), this.tagName(), this, this.engine, null) : this.dialect.createCodeBuilder(this.templateResource.asTemplateContent(), this.name(), this.tagName(), this, this.engine);
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        this.engine();
        if (RythmEngine.insideSandbox()) {
            this.javaSource = CodeBuilder.preventInfiniteLoop(this.javaSource);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(boolean forceRefresh) {
        if (this.refreshing()) {
            return false;
        }
        if (this.inner) {
            return false;
        }
        this.refreshing(true);
        try {
            boolean refresh;
            RythmEngine engine = this.engine();
            if (!this.templateResource.isValid()) {
                this.isValid = false;
                engine.classes().remove(this);
                boolean bl = false;
                return bl;
            }
            ICodeType type = engine.renderSettings.codeType();
            if (null == type) {
                type = this.templateResource.codeType();
            }
            if (null == type || ICodeType.DefImpl.RAW == type) {
                type = engine.conf().defaultCodeType();
            }
            this.codeType = type;
            if (null == this.name) {
                this.root = this;
                this.name = this.templateResource.getSuggestedClassName() + CN_SUFFIX;
                if (engine.conf().typeInferenceEnabled()) {
                    this.name = this.name + ParamTypeInferencer.uuid();
                }
                engine.registerTemplateClass(this);
            }
            if (null == this.javaSource) {
                Pattern p;
                Matcher m;
                engine.classCache().loadTemplateClass(this);
                if (null != this.javaSource && (m = (p = Pattern.compile(".*extends\\s+([a-zA-Z0-9_]+)\\s*\\{\\s*\\/\\/<extended_resource_key\\>(.*)\\<\\/extended_resource_key\\>.*", 32)).matcher(this.javaSource)).matches()) {
                    String extended = m.group(1);
                    TemplateClassManager tcm = this.engine().classes();
                    this.extendedTemplateClass = tcm.getByClassName(extended);
                    if (null == this.extendedTemplateClass) {
                        String extendedResourceKey = m.group(2);
                        this.extendedTemplateClass = tcm.getByTemplate(extendedResourceKey);
                        if (null == this.extendedTemplateClass) {
                            this.extendedTemplateClass = new TemplateClass(extendedResourceKey, this.engine());
                            this.extendedTemplateClass.refresh();
                        }
                    }
                    engine.addExtendRelationship(this.extendedTemplateClass, this);
                }
            }
            boolean extendedTemplateChanged = false;
            if (this.extendedTemplateClass != null) {
                extendedTemplateChanged = this.extendedTemplateClass.refresh(forceRefresh);
            }
            boolean includedTemplateChanged = false;
            if (this.includedTemplateClasses.size() == 0 && !S.isEmpty(this.includeTemplateClassNames) && !NO_INCLUDE_CLASS.equals(this.includeTemplateClassNames)) {
                for (String tcName : this.includeTemplateClassNames.split(",")) {
                    if (S.isEmpty(tcName)) continue;
                    tcName = tcName.trim();
                    String fullName = this.engine().testTemplate(tcName, this);
                    if (null == fullName) {
                        logger.warn("Unable to load included template class from name: %s", tcName);
                        continue;
                    }
                    TemplateClass tc = this.engine().getRegisteredTemplateClass(fullName);
                    if (null == tc) {
                        logger.warn("Unable to load included template class from name: %s", tcName);
                        continue;
                    }
                    this.includedTemplateClasses.add(tc);
                }
            }
            for (TemplateClass tc : this.includedTemplateClasses) {
                if (!tc.refresh(forceRefresh)) continue;
                includedTemplateChanged = true;
                break;
            }
            if (extendedTemplateChanged && !forceRefresh) {
                this.reset();
                this.compiled = false;
                this.engine().restart(new ClassReloadException("extended class changed"));
                this.refreshing(false);
                this.refresh(forceRefresh);
                boolean i$ = true;
                return i$;
            }
            boolean resourceChanged = this.templateResource.refresh();
            boolean bl = refresh = resourceChanged || forceRefresh || null == this.javaSource || includedTemplateChanged || extendedTemplateChanged;
            if (!refresh) {
                boolean bl2 = false;
                return bl2;
            }
            this.reset();
            this.buildSourceCode();
            this.engine().classCache().cacheTemplateClassSource(this);
            if (!this.codeBuilder.isRythmTemplate()) {
                this.isValid = false;
                this.engine().classes().remove(this);
                boolean bl3 = false;
                return bl3;
            }
            this.isValid = true;
            this.compiled = false;
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.refreshing(false);
        }
    }

    public boolean isDefinable() {
        return this.compiled && this.javaClass != null;
    }

    public void reset() {
        this.javaByteCode = null;
        this.enhancedByteCode = null;
        this.javaSource = null;
        this.templateInstance = null;
        for (TemplateClass tc : this.embeddedClasses) {
            tc.reset();
            this.engine().classes().remove(tc);
        }
        this.embeddedClasses.clear();
        this.engine().classCache().deleteCache(this);
        this.engine().invalidate(this);
        this.javaClass = null;
    }

    public byte[] compile() {
        if (null != this.javaByteCode) {
            return this.javaByteCode;
        }
        if (null == this.javaSource) {
            throw new IllegalStateException("Cannot find java source when compiling " + this.getKey());
        }
        this.compiling = true;
        long start = System.currentTimeMillis();
        try {
            this.engine().classes().compiler.compile(new String[]{this.name()});
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template: %s", System.currentTimeMillis() - start, this.getKey());
            }
        }
        catch (CompileException.CompilerException e) {
            TemplateClass tc;
            String cn = e.className;
            TemplateClass templateClass = tc = S.isEqual(cn, this.name()) ? this : this.engine().classes().getByClassName(cn);
            if (null == tc) {
                tc = this;
            }
            CompileException ce = new CompileException(this.engine(), tc, e.javaLineNumber, e.message);
            this.javaSource = null;
            throw ce;
        }
        catch (NullPointerException e) {
            String clazzName = this.name();
            TemplateClass tc = this.engine().classes().getByClassName(clazzName);
            if (this != tc) {
                logger.error("tc is not this", new Object[0]);
            }
            if (!this.equals(tc)) {
                logger.error("tc not match this", new Object[0]);
            }
            logger.error("NPE encountered when compiling template class:" + this.name(), new Object[0]);
            throw e;
        }
        finally {
            this.compiling = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey());
        }
        return this.javaByteCode;
    }

    public void delayedEnhance(TemplateClass root) {
        this.enhancedByteCode = this.javaByteCode;
        root.embeddedClasses.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] enhance() {
        if (this.enhancing) {
            throw new IllegalStateException("reenter enhance() call");
        }
        this.enhancing = true;
        try {
            byte[] bytes = this.enhancedByteCode;
            if (null == bytes) {
                bytes = this.javaByteCode;
                if (null == bytes) {
                    bytes = this.compile();
                }
                long start = System.currentTimeMillis();
                IByteCodeEnhancer en = this.engine().conf().byteCodeEnhancer();
                if (null != en) {
                    try {
                        bytes = en.enhance(this.name(), bytes);
                    }
                    catch (Exception e) {
                        logger.warn(e, "Error enhancing template class: %s", this.getKey());
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("%sms to enhance template class %s", System.currentTimeMillis() - start, this.getKey());
                    }
                }
                this.enhancedByteCode = bytes;
                this.engine().classCache().cacheTemplateClass(this);
            }
            for (TemplateClass embedded : this.embeddedClasses) {
                embedded.enhancedByteCode = null;
                embedded.enhance();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            this.enhancing = false;
        }
    }

    public void uncompile() {
        this.javaClass = null;
    }

    public boolean isClass() {
        return !this.name().endsWith("package-info");
    }

    public String getPackage() {
        int dot = this.name().lastIndexOf(46);
        return dot > -1 ? this.name().substring(0, dot) : "";
    }

    public void loadCachedByteCode(byte[] code) {
        this.enhancedByteCode = code;
    }

    public void compiled(byte[] code) {
        this.javaByteCode = code;
        this.compiled = true;
        this.enhance();
    }

    public String toString() {
        return "(compiled:" + this.compiled + ") " + this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateClass) {
            TemplateClass that = (TemplateClass)o;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    private class RefreshLock {
        CountDownLatch cdl = new CountDownLatch(1);

        private RefreshLock() {
        }

        public void close() {
            this.cdl.countDown();
        }

        public void waitTillOpen() {
            try {
                this.cdl.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

