/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class RythmThreadFactory
implements ThreadFactory {
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;

    protected RythmThreadFactory(String poolName) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = poolName + "-thread-";
    }

    protected Thread newThread0(ThreadGroup g, Runnable r, String name, long stackSize) {
        return new Thread(g, r, name, stackSize);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.newThread0(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

