/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.HashMap;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IRenderExceptionHandler;
import org.rythmengine.extension.IRythmListener;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.IEventDispatcher;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.F;

public class EventBus
implements IEventDispatcher {
    private final RythmEngine engine;
    private final ISourceCodeEnhancer sourceCodeEnhancer;
    private final IRenderExceptionHandler exceptionHandler;
    private final IRythmListener renderListener;
    private Map<IEvent<?, ?>, IEventHandler<?, ?>> dispatcher = new HashMap();

    public EventBus(RythmEngine engine) {
        this.engine = engine;
        RythmConfiguration conf = engine.conf();
        this.sourceCodeEnhancer = (ISourceCodeEnhancer)conf.get(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER);
        this.exceptionHandler = (IRenderExceptionHandler)conf.get(RythmConfigurationKey.RENDER_EXCEPTION_HANDLER);
        this.renderListener = (IRythmListener)conf.get(RythmConfigurationKey.RENDER_LISTENER);
        this.registerHandlers();
    }

    @Override
    public Object accept(IEvent event, Object param) {
        IEventHandler<?, ?> handler = this.dispatcher.get(event);
        if (null != handler) {
            return handler.handleEvent(this.engine, param);
        }
        return null;
    }

    private void registerHandlers() {
        Map<IEvent<?, ?>, IEventHandler<?, ?>> m = this.dispatcher;
        m.put(RythmEvents.ON_PARSE, new IEventHandler<String, CodeBuilder>(){

            @Override
            public String handleEvent(RythmEngine engine, CodeBuilder c) {
                String tmpl = c.template();
                tmpl = tmpl.replaceAll("(\\r\\n)", "\n");
                tmpl = tmpl.replaceAll("\\r", "\n");
                return tmpl;
            }
        });
        m.put(RythmEvents.ON_BUILD_JAVA_SOURCE, new IEventHandler<Void, CodeBuilder>(){

            @Override
            public Void handleEvent(RythmEngine engine, CodeBuilder cb) {
                ISourceCodeEnhancer ce = EventBus.this.sourceCodeEnhancer;
                if (null == ce) {
                    return null;
                }
                if (cb.basicTemplate()) {
                    return null;
                }
                Map<String, ?> defArgs = ce.getRenderArgDescriptions();
                for (String name : defArgs.keySet()) {
                    Object o = defArgs.get(name);
                    String type = o instanceof Class ? ((Class)o).getName() : o.toString();
                    cb.addRenderArgs(-1, type, name);
                }
                for (String s : ce.imports()) {
                    cb.addImport(s, -1);
                }
                return null;
            }
        });
        m.put(RythmEvents.ON_CLOSING_JAVA_CLASS, new IEventHandler<Void, CodeBuilder>(){

            @Override
            public Void handleEvent(RythmEngine engine, CodeBuilder cb) {
                ISourceCodeEnhancer ce = EventBus.this.sourceCodeEnhancer;
                if (null == ce) {
                    return null;
                }
                if (cb.basicTemplate()) {
                    return null;
                }
                cb.np(ce.sourceCode());
                cb.pn();
                return null;
            }
        });
        m.put(RythmEvents.ON_RENDER, new IEventHandler<Void, ITemplate>(){

            @Override
            public Void handleEvent(RythmEngine engine, ITemplate template) {
                IRythmListener l;
                ISourceCodeEnhancer ce = (ISourceCodeEnhancer)engine.conf().get(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER);
                if (null != ce) {
                    ce.setRenderArgs(template);
                }
                if (null == (l = EventBus.this.renderListener)) {
                    return null;
                }
                l.onRender(template);
                return null;
            }
        });
        m.put(RythmEvents.RENDERED, new IEventHandler<Void, ITemplate>(){

            @Override
            public Void handleEvent(RythmEngine engine, ITemplate template) {
                engine.renderSettings.clear();
                Rythm.RenderTime.clear();
                IRythmListener l = EventBus.this.renderListener;
                if (null != l) {
                    l.rendered(template);
                }
                return null;
            }
        });
        m.put(RythmEvents.ON_TAG_INVOCATION, new IEventHandler<Void, F.T2<ITemplate, ITag>>(){

            @Override
            public Void handleEvent(RythmEngine engine, F.T2<ITemplate, ITag> param) {
                IRythmListener l = EventBus.this.renderListener;
                if (null == l) {
                    return null;
                }
                ITag tag = (ITag)param._2;
                l.onInvoke(tag);
                return null;
            }
        });
        m.put(RythmEvents.TAG_INVOKED, new IEventHandler<Void, F.T2<TemplateBase, ITag>>(){

            @Override
            public Void handleEvent(RythmEngine engine, F.T2<TemplateBase, ITag> param) {
                IRythmListener l = EventBus.this.renderListener;
                if (null == l) {
                    return null;
                }
                ITag tag = (ITag)param._2;
                l.invoked(tag);
                return null;
            }
        });
        m.put(RythmEvents.ON_RENDER_EXCEPTION, new IEventHandler<Boolean, F.T2<TemplateBase, Exception>>(){

            @Override
            public Boolean handleEvent(RythmEngine engine, F.T2<TemplateBase, Exception> param) {
                return EventBus.this.exceptionHandler.handleTemplateExecutionException((Exception)param._2, (TemplateBase)param._1);
            }
        });
    }

    private static interface IEventHandler<RETURN, PARAM> {
        public RETURN handleEvent(RythmEngine var1, PARAM var2);
    }
}

