/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rythmengine.RythmEngine;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.ToStringTemplateBase;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.dialect.AutoToString;
import org.rythmengine.internal.parser.toString.AppendEndToken;
import org.rythmengine.internal.parser.toString.AppendFieldToken;
import org.rythmengine.internal.parser.toString.AppendStartToken;
import org.rythmengine.toString.ToStringOption;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class AutoToStringCodeBuilder
extends CodeBuilder {
    private AutoToString.AutoToStringData meta = null;
    private Map<String, String> expressions = new HashMap<String, String>();
    private Set<String> transients = new HashSet<String>();
    private Set<String> skips = new HashSet<String>();
    private Set<String> skipAnnotations = new HashSet<String>();
    private Set<String> transientAnnotations = new HashSet<String>();
    private List<String> tokenList = new ArrayList<String>();

    public AutoToStringCodeBuilder(String template, String className, String tagName, TemplateClass templateClass, RythmEngine engine, IDialect dialect) {
        super(template, className, tagName, templateClass, engine, dialect);
        this.skipAnnotations.addAll(Arrays.asList("org.codehaus.jackson.annotate.JsonIgnore org.rythmengine.toString.NoExpose ".split(" +")));
        this.transientAnnotations.addAll(Arrays.asList("javax.persistence.Transient com.google.code.morphia.annotations.Transient".split(" +")));
        this.meta = ((AutoToString)dialect).meta;
    }

    @Override
    protected String extended() {
        return ToStringTemplateBase.class.getName();
    }

    @Override
    protected void pSetup() {
        this.ptn("@Override protected void __setup() {");
        if (this.logTime) {
            this.p2tn("__logTime = true;");
        }
        this.p2t("__style = ").p(this.meta.style.toCode()).p(";").pn();
        for (String argName : this.renderArgs.keySet()) {
            CodeBuilder.RenderArgDeclaration arg = (CodeBuilder.RenderArgDeclaration)this.renderArgs.get(argName);
            this.p2t("if (").p(argName).p(" == null) {");
            this.p(argName).p("=(").p(arg.type).p(")__get(\"").p(argName).p("\");}\n");
        }
        this.ptn("}");
    }

    @Override
    public TextBuilder build() {
        this.parse();
        this.pImports();
        this.pClassOpen();
        this.pRenderArgs();
        this.pSetup();
        this.pBuild();
        this.pClassClose();
        return this;
    }

    private boolean shouldSkip(Annotation[] aa) {
        for (Annotation a : aa) {
            String an = a.annotationType().getName();
            if (this.skipAnnotations.contains(an)) {
                return true;
            }
            if (!this.transientAnnotations.contains(an) || this.meta.option.appendTransient) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSkip(Field f) {
        String fn = f.getName();
        Annotation[] aa = f.getAnnotations();
        if (this.shouldSkip(aa)) {
            this.skips.add(fn);
            return true;
        }
        int mod = f.getModifiers();
        ToStringOption op = this.meta.option;
        if (!op.appendTransient && Modifier.isTransient(mod) || !op.appendStatic && Modifier.isStatic(mod)) {
            this.skips.add(fn);
            return true;
        }
        return !Modifier.isPublic(mod);
    }

    private boolean shouldSkip(Method m, String fn) {
        Annotation[] aa = m.getAnnotations();
        if (this.shouldSkip(aa)) {
            this.skips.add(fn);
            return true;
        }
        int mod = m.getModifiers();
        ToStringOption op = this.meta.option;
        if (!op.appendTransient && Modifier.isTransient(mod) || !op.appendStatic && Modifier.isStatic(mod)) {
            this.skips.add(fn);
            return true;
        }
        return !Modifier.isPublic(mod);
    }

    private void appendFieldsIn(Class<?> c) {
        Field[] fa;
        ToStringOption o = this.meta.option;
        for (Field f : fa = c.getDeclaredFields()) {
            String fn = f.getName();
            if (!this.tokenList.contains(fn)) {
                this.tokenList.add(fn);
            }
            if (this.shouldSkip(f)) continue;
            this.expressions.put(fn, fn);
        }
    }

    private void appendMethodsIn(Class<?> c) {
        Method[] ma;
        ToStringOption o = this.meta.option;
        for (Method m : ma = c.getDeclaredMethods()) {
            String mn = m.getName();
            if ("getClass".equals(mn)) continue;
            String fn = null;
            if (mn.startsWith("get")) {
                fn = mn.replaceFirst("get", "");
            } else if (mn.startsWith("is")) {
                fn = mn.replaceFirst("is", "");
            }
            if (S.isEmpty(fn) || this.shouldSkip(m, fn = S.lowerFirst(fn))) continue;
            mn = mn + "()";
            if (!this.tokenList.contains(fn)) {
                this.tokenList.add(fn);
            }
            this.expressions.put(fn, mn);
        }
    }

    private void appendIn(Class<?> c) {
        if (this.engine().conf().playFramework()) {
            this.appendMethodsIn(c);
            this.appendFieldsIn(c);
        } else {
            this.appendFieldsIn(c);
            this.appendMethodsIn(c);
        }
    }

    private void parse() {
        Class<?> c;
        ToStringOption o = this.meta.option;
        this.addBuilder(new AppendStartToken(this));
        this.appendIn(c);
        for (c = this.meta.clazz; c.getSuperclass() != null && c != o.upToClass; c = c.getSuperclass()) {
            this.appendIn(c);
        }
        for (String fn : this.skips) {
            this.expressions.remove(fn);
        }
        for (String fn : this.tokenList) {
            if (!this.expressions.containsKey(fn)) continue;
            String exp = this.expressions.get(fn);
            this.addBuilder(new AppendFieldToken(fn, exp, this));
        }
        this.addBuilder(new AppendEndToken(this));
        this.addRenderArgs(-1, this.meta.clazz.getName().replace('$', '.'), "_");
    }
}

