/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.conf;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine._Rythm;
import org.rythmengine.cache.NoCacheService;
import org.rythmengine.cache.SimpleCacheService;
import org.rythmengine.exception.ConfigurationException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.logger.JDKLogger;
import org.rythmengine.utils.S;

public enum RythmConfigurationKey {
    BUILT_IN_CODE_TYPE_ENABLED("built_in.code_type.enabled", true),
    BUILT_IN_TRANSFORMER_ENABLED("built_in.transformer.enabled", true),
    CACHE_ENABLED("cache.enabled", false),
    CACHE_SERVICE_IMPL("cache.service.impl"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            Boolean cacheEnabled = (Boolean)CACHE_ENABLED.getConfiguration(configuration);
            return cacheEnabled != false ? SimpleCacheService.INSTANCE : NoCacheService.INSTANCE;
        }
    }
    ,
    CACHE_DURATION_PARSER_IMPL("cache.duration_parser.impl", IDurationParser.DEFAULT_PARSER),
    CACHE_PROD_ONLY_ENABLED("cache.prod_only.enabled", true),
    CODEGEN_COMPACT_ENABLED("codegen.compact.enabled", true),
    CODEGEN_SOURCE_CODE_ENHANCER("codegen.source_code_enhancer.impl"),
    CODEGEN_BYTE_CODE_ENHANCER("codegen.byte_code_enhancer.impl"),
    DEFAULT_CODE_TYPE_IMPL("default.code_type.impl", ICodeType.DefImpl.RAW),
    DEFAULT_CACHE_TTL("default.cache_ttl"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(3600);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    ENGINE_MODE("engine.mode"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)((Object)Rythm.Mode.prod);
            }
            if (v instanceof Rythm.Mode) {
                return (T)v;
            }
            return (T)((Object)Rythm.Mode.valueOf(v.toString()));
        }
    }
    ,
    ENGINE_ID("engine.id"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            return "re-" + S.random(3);
        }
    }
    ,
    ENGINE_CLASS_LOADER_PARENT_IMPL("engine.class_loader.parent.impl"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (null == cl) {
                cl = Rythm.class.getClassLoader();
            }
            return cl;
        }
    }
    ,
    ENGINE_CLASS_LOADER_BYTE_CODE_HELPER_IMPL("engine.class_loader.byte_code_helper.impl"),
    ENGINE_LOAD_PRECOMPILED_ENABLED("engine.load_precompiled.enabled", false),
    ENGINE_FILE_WRITE_ENABLED("engine.file_write.enabled", true),
    ENGINE_PRECOMPILE_MODE("engine.precompile_mode.enabled"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Boolean.FALSE;
            }
            if (v instanceof Boolean) {
                return (T)v;
            }
            return (T)Boolean.valueOf(v.toString());
        }
    }
    ,
    ENGINE_OUTPUT_JAVA_SOURCE_ENABLED("engine.debug_java_source.enabled", false),
    ENGINE_PLAYFRAMEWORK("engine.playframework.enabled", false),
    ENGINE_PLUGIN_VERSION("engine.plugin.version", ""),
    FEATURE_TRANSFORM_ENABLED("feature.transform.enabled", true),
    FEATURE_TYPE_INFERENCE_ENABLED("feature.type_inference.enabled", false),
    FEATURE_SMART_ESCAPE_ENABLED("feature.smart_escape.enabled", true),
    FEATURE_NATURAL_TEMPLATE_ENABLED("feature.natural_template.enabled", false),
    HOME_TEMPLATE("home.template.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            URL url = Thread.currentThread().getContextClassLoader().getResource("rythm");
            if (null != url) {
                return new File(url.getPath());
            }
            return new File("rythm");
        }
    }
    ,
    HOME_TMP("home.tmp.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            return new File(System.getProperty("java.io.tmpdir"), "__rythm");
        }
    }
    ,
    HOME_PRECOMPILED("home.precompiled.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            return null;
        }
    }
    ,
    I18N_LOCALE("i18n.locale"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            Locale retval;
            String k = this.getKey();
            Object o = configuration.get(k);
            if (o instanceof Locale) {
                return (T)o;
            }
            String s = S.str(o);
            if (S.empty(s)) {
                return (T)Locale.getDefault();
            }
            String[] sa = s.split("_");
            String lang = sa[0];
            if (sa.length > 1) {
                String region = sa[1];
                retval = new Locale(lang, region);
            } else {
                retval = new Locale(lang);
            }
            return (T)retval;
        }
    }
    ,
    I18N_MESSAGE_SOURCES("i18n.message.sources", "messages"),
    I18N_MESSAGE_RESOLVER("i18n.message.resolver.impl", II18nMessageResolver.DefaultImpl.INSTANCE),
    LOG_ENABLED("log.enabled", true),
    LOG_FACTORY_IMPL("log.factory.impl", JDKLogger.Factory.class),
    LOG_SOURCE_JAVA_ENABLED("log.source.java.enabled", true),
    LOG_SOURCE_TEMPLATE_ENABLED("log.source.template.enabled", true),
    LOG_TIME_RENDER_ENABLED("log.time.render.enabled", false),
    RENDER_LISTENER("render.listener.impl"),
    RENDER_EXCEPTION_HANDLER("render.exception_handler.impl"),
    RESOURCE_LOADER_IMPL("resource.loader.impl"),
    RESOURCE_NAME_SUFFIX("resource.name.suffix", ""){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String s = (String)super.getConfiguration(configuration);
            if (S.empty(s)) {
                return (T)"";
            }
            if (!s.startsWith(".")) {
                s = "." + s;
            }
            return (T)s;
        }
    }
    ,
    SANDBOX_SECURITY_MANAGER_IMPL("sandbox.security_manager.impl"),
    SANDBOX_TIMEOUT("sandbox.timeout"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(2000);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    SANDBOX_POOL_SIZE("sandbox.pool.size"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(10);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    SANDBOX_RESTRICTED_CLASS("sandbox.restricted_class", ""),
    SANDBOX_ALLOWED_SYSTEM_PROPERTIES("sandbox.allowed_system_properties", "java.io.tmpdir,file.encoding,user.dir,line.separator,java.vm.name,java.protocol.handler.pkgs,suppressRawWhenUnchecked"),
    SANBOX_THREAD_FACTORY_IMPL("sandbox.thread_factory.impl", (Object)null),
    TRANSFORMER_UDT("transformer.udt");

    private String key;
    private Object defVal;
    private static Map<String, RythmConfigurationKey> lookup;

    private RythmConfigurationKey(String key) {
        this(key, (Object)null);
    }

    private RythmConfigurationKey(String key, Object defVal) {
        this.key = key;
        this.defVal = defVal;
    }

    public String getKey() {
        return this.key;
    }

    protected Object getDefVal(Map<String, ?> configuration) {
        return this.defVal;
    }

    public String toString() {
        return this.key;
    }

    private static List<String> aliases(String key, String suffix) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("rythm." + key);
        l.add(key);
        if (S.notEmpty(suffix)) {
            String k0 = key.replace("." + suffix, "");
            l.add("rythm." + k0);
            l.add(k0);
        }
        return l;
    }

    private Object getValFromAliases(Map<String, ?> configuration, String key, String suffix) {
        Object v = configuration.get(key);
        if (null == v) {
            String k0;
            Iterator<String> i$ = RythmConfigurationKey.aliases(key, suffix).iterator();
            while (i$.hasNext() && null == (v = configuration.get(k0 = i$.next()))) {
            }
            if (null == v) {
                v = this.getDefVal(configuration);
            }
        }
        return v;
    }

    private static boolean toBoolean(Object v) {
        if (null == v) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.parseBoolean(v.toString());
    }

    private Boolean getEnabled(String key, Map<String, ?> configuration) {
        Object v = this.getValFromAliases(configuration, key, "enabled");
        if (null == v) {
            v = this.getValFromAliases(configuration, key, "disabled");
            return !RythmConfigurationKey.toBoolean(v);
        }
        return RythmConfigurationKey.toBoolean(v);
    }

    private <T> T getImpl(String key, Map<String, ?> configuration) {
        Object v = this.getValFromAliases(configuration, key, "impl");
        if (null == v) {
            return null;
        }
        if (v instanceof Class) {
            try {
                return ((Class)v).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException(e, "Error getting implementation configuration: %s", key);
            }
        }
        if (!(v instanceof String)) {
            return (T)v;
        }
        String clsName = (String)v;
        try {
            return (T)Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            try {
                Object o = _Rythm.eval(clsName);
                if (o instanceof Class) {
                    return ((Class)o).newInstance();
                }
                return (T)o;
            }
            catch (Exception e1) {
                throw new ConfigurationException(e, "Error getting implementation configuration: %s", key);
            }
        }
    }

    private File getFile(String key, Map<String, ?> configuration) {
        Object v = this.getValFromAliases(configuration, key, "dir");
        if (null == v) {
            return null;
        }
        if (v instanceof File) {
            return (File)v;
        }
        String s = v.toString();
        boolean isAbsolute = false;
        if (s.startsWith("/") || s.startsWith(File.separator)) {
            isAbsolute = true;
        } else if (s.matches("^[a-zA-Z]:.*")) {
            isAbsolute = true;
        }
        if (isAbsolute) {
            return new File(s);
        }
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(s);
            return new File(url.getPath());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "Error reading file configuration %s", key);
        }
    }

    public <T> T getConfiguration(Map<String, ?> configuration) {
        String key = this.key;
        if (key.endsWith(".enabled")) {
            return (T)this.getEnabled(key, configuration);
        }
        if (key.endsWith(".impl")) {
            return this.getImpl(key, configuration);
        }
        if (key.endsWith(".dir")) {
            return (T)this.getFile(key, configuration);
        }
        return (T)this.getValFromAliases(configuration, key, null);
    }

    public <T> T getDefaultConfiguration() {
        return this.getConfiguration(Collections.emptyMap());
    }

    public static RythmConfigurationKey valueOfIgnoreCase(String s) {
        if (S.empty(s)) {
            throw new IllegalArgumentException();
        }
        return lookup.get(s.trim().toLowerCase());
    }

    static {
        lookup = new HashMap<String, RythmConfigurationKey>(50);
        for (RythmConfigurationKey k : RythmConfigurationKey.values()) {
            lookup.put(k.getKey().toLowerCase(), k);
        }
    }
}

