/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.conf;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IByteCodeEnhancer;
import org.rythmengine.extension.IByteCodeHelper;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.RawData;

public class RythmConfiguration {
    private Map<String, Object> raw;
    private Map<RythmConfigurationKey, Object> data;
    private String _pluginVersion = null;
    private IByteCodeHelper _byteCodeHelper = null;
    private Boolean _play = false;
    private Boolean _logRenderTime = null;
    private Boolean _loadPrecompiled = null;
    private Boolean _precompileMode = null;
    private Boolean _disableFileWrite = null;
    private Set<String> _restrictedClasses = null;
    private Boolean _enableTypeInference = null;
    private Boolean _smartEscapeEnabled = null;
    private Boolean _naturalTemplateEnabled = null;
    private Boolean _debugJavaSourceEnabled = null;
    private Boolean _cacheEnabled = null;
    private Boolean _transformEnabled = null;
    private Boolean _compactEnabled = null;
    private IDurationParser _durationParser = null;
    private ICodeType _defaultCodeType = null;
    private File _tmpDir = null;
    private File _templateHome = null;
    private IByteCodeEnhancer _byteCodeEnhancer = IByteCodeEnhancer.INSTS.NULL;
    private Locale _locale = null;
    private List<String> _messageSources = null;
    private II18nMessageResolver _i18n = null;
    private String _suffix = null;
    private String _allowedSysProps = null;
    public static final RythmConfiguration EMPTY_CONF = new RythmConfiguration(Collections.EMPTY_MAP);
    private static ILogger logger = Logger.get(RythmConfiguration.class);

    public RythmConfiguration(Map<String, ?> configuration) {
        this.raw = new HashMap(configuration);
        this.data = new HashMap<RythmConfigurationKey, Object>(configuration.size());
    }

    public <T> T get(RythmConfigurationKey key) {
        Object o = this.data.get((Object)key);
        if (null == o) {
            o = key.getConfiguration(this.raw);
            if (null != o) {
                this.data.put(key, o);
            } else {
                this.data.put(key, RawData.NULL);
            }
        }
        if (o == RawData.NULL) {
            return null;
        }
        return (T)o;
    }

    public <T> T get(String key) {
        RythmConfigurationKey rk;
        if (key.startsWith("rythm.")) {
            key = key.replaceFirst("rythm.", "");
        }
        if (null != (rk = RythmConfigurationKey.valueOfIgnoreCase(key))) {
            return this.get(rk);
        }
        return (T)this.raw.get(key);
    }

    public String pluginVersion() {
        if (null == this._pluginVersion) {
            this._pluginVersion = (String)this.get(RythmConfigurationKey.ENGINE_PLUGIN_VERSION);
        }
        return this._pluginVersion;
    }

    public IByteCodeHelper byteCodeHelper() {
        if (null == this._byteCodeHelper) {
            this._byteCodeHelper = (IByteCodeHelper)this.get(RythmConfigurationKey.ENGINE_CLASS_LOADER_BYTE_CODE_HELPER_IMPL);
        }
        return this._byteCodeHelper;
    }

    public boolean playFramework() {
        if (null == this._play) {
            this._play = (Boolean)this.get(RythmConfigurationKey.ENGINE_PLAYFRAMEWORK);
        }
        return this._play;
    }

    public boolean logRenderTime() {
        if (null == this._logRenderTime) {
            this._logRenderTime = (Boolean)this.get(RythmConfigurationKey.LOG_TIME_RENDER_ENABLED);
        }
        return this._logRenderTime;
    }

    public boolean loadPrecompiled() {
        if (null == this._loadPrecompiled) {
            this._loadPrecompiled = (Boolean)this.get(RythmConfigurationKey.ENGINE_LOAD_PRECOMPILED_ENABLED);
        }
        return this._loadPrecompiled;
    }

    public boolean precompileMode() {
        if (null == this._precompileMode) {
            this._precompileMode = (Boolean)this.get(RythmConfigurationKey.ENGINE_PRECOMPILE_MODE);
        }
        return this._precompileMode;
    }

    public boolean disableFileWrite() {
        if (null == this._disableFileWrite) {
            boolean b = (Boolean)this.get(RythmConfigurationKey.ENGINE_FILE_WRITE_ENABLED);
            this._disableFileWrite = !b;
        }
        return this._disableFileWrite;
    }

    public Set<String> restrictedClasses() {
        if (null == this._restrictedClasses) {
            String s = (String)this.get(RythmConfigurationKey.SANDBOX_RESTRICTED_CLASS);
            s = s + ";org.rythmengine.Rythm;RythmEngine;RythmSecurityManager,java.io;java.nio;java.security;java.rmi;java.net;java.awt;java.applet";
            this._restrictedClasses = new HashSet<String>();
            for (String cls : Arrays.asList(s.split(";"))) {
                if ("".equals(cls = cls.trim())) continue;
                this._restrictedClasses.add(cls);
            }
        }
        return new HashSet<String>(this._restrictedClasses);
    }

    public boolean typeInferenceEnabled() {
        if (null == this._enableTypeInference) {
            this._enableTypeInference = (Boolean)this.get(RythmConfigurationKey.FEATURE_TYPE_INFERENCE_ENABLED);
        }
        return this._enableTypeInference;
    }

    public boolean smartEscapeEnabled() {
        if (null == this._smartEscapeEnabled) {
            this._smartEscapeEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_SMART_ESCAPE_ENABLED);
        }
        return this._smartEscapeEnabled;
    }

    public boolean naturalTemplateEnabled() {
        if (null == this._naturalTemplateEnabled) {
            this._naturalTemplateEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_NATURAL_TEMPLATE_ENABLED);
        }
        return this._naturalTemplateEnabled;
    }

    public boolean debugJavaSourceEnabled() {
        if (null == this._debugJavaSourceEnabled) {
            this._debugJavaSourceEnabled = (Boolean)this.get(RythmConfigurationKey.ENGINE_OUTPUT_JAVA_SOURCE_ENABLED);
        }
        return this._debugJavaSourceEnabled;
    }

    public boolean cacheEnabled() {
        if (null == this._cacheEnabled) {
            boolean ce = (Boolean)this.get(RythmConfigurationKey.CACHE_ENABLED);
            Rythm.Mode mode = (Rythm.Mode)((Object)this.get(RythmConfigurationKey.ENGINE_MODE));
            boolean po = (Boolean)this.get(RythmConfigurationKey.CACHE_PROD_ONLY_ENABLED);
            this._cacheEnabled = !ce ? Boolean.valueOf(false) : Boolean.valueOf(!mode.isDev() || !po);
        }
        return this._cacheEnabled;
    }

    public boolean cacheDisabled() {
        return !this.cacheEnabled();
    }

    public boolean transformEnabled() {
        if (null == this._transformEnabled) {
            this._transformEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_TRANSFORM_ENABLED);
        }
        return this._transformEnabled;
    }

    public boolean compactModeEnabled() {
        if (null == this._compactEnabled) {
            this._compactEnabled = (Boolean)this.get(RythmConfigurationKey.CODEGEN_COMPACT_ENABLED);
        }
        return this._compactEnabled;
    }

    public IDurationParser durationParser() {
        if (null == this._durationParser) {
            this._durationParser = (IDurationParser)this.get(RythmConfigurationKey.CACHE_DURATION_PARSER_IMPL);
        }
        return this._durationParser;
    }

    public ICodeType defaultCodeType() {
        if (null == this._defaultCodeType) {
            this._defaultCodeType = (ICodeType)this.get(RythmConfigurationKey.DEFAULT_CODE_TYPE_IMPL);
        }
        return this._defaultCodeType;
    }

    public File tmpDir() {
        if (null == this._tmpDir) {
            this._tmpDir = (File)this.get(RythmConfigurationKey.HOME_TMP);
        }
        return this._tmpDir;
    }

    public File templateHome() {
        if (null == this._templateHome) {
            this._templateHome = (File)this.get(RythmConfigurationKey.HOME_TEMPLATE);
        }
        return this._templateHome;
    }

    public void setTemplateHome(File home) {
        this.raw.put(RythmConfigurationKey.HOME_TEMPLATE.getKey(), home);
        this.data.put(RythmConfigurationKey.HOME_TEMPLATE, home);
    }

    public IByteCodeEnhancer byteCodeEnhancer() {
        if (IByteCodeEnhancer.INSTS.NULL == this._byteCodeEnhancer) {
            this._byteCodeEnhancer = (IByteCodeEnhancer)this.get(RythmConfigurationKey.CODEGEN_BYTE_CODE_ENHANCER);
        }
        return this._byteCodeEnhancer;
    }

    public Locale locale() {
        if (null == this._locale) {
            this._locale = (Locale)this.get(RythmConfigurationKey.I18N_LOCALE);
        }
        return this._locale;
    }

    public List<String> messageSources() {
        if (null == this._messageSources) {
            this._messageSources = Arrays.asList(this.get(RythmConfigurationKey.I18N_MESSAGE_SOURCES).toString().split("[, \\t]+"));
        }
        return this._messageSources;
    }

    public II18nMessageResolver i18nMessageResolver() {
        if (null == this._i18n) {
            this._i18n = (II18nMessageResolver)this.get(RythmConfigurationKey.I18N_MESSAGE_RESOLVER);
        }
        return this._i18n;
    }

    public String resourceNameSuffix() {
        if (null == this._suffix) {
            this._suffix = (String)this.get(RythmConfigurationKey.RESOURCE_NAME_SUFFIX);
        }
        return this._suffix;
    }

    public String allowedSystemProperties() {
        if (null == this._allowedSysProps) {
            this._allowedSysProps = (String)this.get(RythmConfigurationKey.SANDBOX_ALLOWED_SYSTEM_PROPERTIES);
        }
        return this._allowedSysProps;
    }

    public static RythmConfiguration get() {
        RythmEngine engine = RythmEngine.get();
        return null != engine ? engine.conf() : EMPTY_CONF;
    }

    public void debug() {
        logger.info("start to dump rythm configuration >>>", new Object[0]);
        for (RythmConfigurationKey k : RythmConfigurationKey.values()) {
            logger.info("%s: %s", new Object[]{k, this.get(k)});
        }
        logger.info("end dumping rythm configuration <<<", new Object[0]);
    }
}

