/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine;

import java.io.File;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.sandbox.SandboxExecutingService;

public class Sandbox {
    private static final InheritableThreadLocal<Boolean> sandboxMode = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    RythmEngine engine;
    SandboxExecutingService secureExecutor = null;
    private Map<String, Object> userContext;

    static boolean sandboxMode() {
        return (Boolean)sandboxMode.get();
    }

    public Sandbox(RythmEngine engine, SandboxExecutingService executor) {
        this.engine = engine;
        this.secureExecutor = executor;
    }

    private RythmEngine engine() {
        if (null != this.engine) {
            return this.engine;
        }
        return Rythm.engine();
    }

    public Sandbox setUserContext(Map<String, Object> context) {
        this.userContext = context;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(String template, Object ... args) {
        sandboxMode.set(true);
        try {
            String string = this.secureExecutor.execute(this.userContext, template, args);
            return string;
        }
        finally {
            sandboxMode.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(File file, Object ... args) {
        sandboxMode.set(true);
        try {
            String string = this.secureExecutor.execute(this.userContext, file, args);
            return string;
        }
        finally {
            sandboxMode.set(false);
        }
    }

    public static String hasAccessToRestrictedClasses(RythmEngine engine, String code) {
        for (String s : engine.conf().restrictedClasses()) {
            if (!code.contains(s)) continue;
            return s;
        }
        return null;
    }
}

