/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.rythmengine.Rythm;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.exception.RythmException;
import org.rythmengine.exception.TagLoadException;
import org.rythmengine.extension.ICacheService;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.ILoggerFactory;
import org.rythmengine.extension.Transformer;
import org.rythmengine.internal.EventBus;
import org.rythmengine.internal.ExtensionManager;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.IEventDispatcher;
import org.rythmengine.internal.IJavaExtension;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.compiler.TemplateClassCache;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.internal.dialect.AutoToString;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.dialect.DialectManager;
import org.rythmengine.internal.dialect.ToString;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.logger.NullLogger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.resource.TemplateResourceManager;
import org.rythmengine.resource.ToStringTemplateResource;
import org.rythmengine.sandbox.SandboxExecutingService;
import org.rythmengine.sandbox.SandboxThreadFactory;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.JavaTagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.toString.ToStringOption;
import org.rythmengine.toString.ToStringStyle;
import org.rythmengine.utils.F;
import org.rythmengine.utils.IO;
import org.rythmengine.utils.JSONWrapper;
import org.rythmengine.utils.S;

public class RythmEngine
implements IEventDispatcher {
    private static final ILogger logger = Logger.get(RythmEngine.class);
    private static final String version = IO.readContentAsString(RythmEngine.class.getClassLoader().getResourceAsStream("rythm-engine-version"));
    private static final InheritableThreadLocal<RythmEngine> _engine = new InheritableThreadLocal();
    private RythmConfiguration _conf = null;
    private Rythm.Mode _mode = null;
    private String _id = null;
    private TemplateResourceManager _resourceManager;
    private TemplateClassManager _classes;
    private TemplateClassLoader _classLoader = null;
    private TemplateClassCache _classCache = null;
    private ExtensionManager _extensionManager;
    private final DialectManager _dialectManager = new DialectManager();
    private ICacheService _cacheService = null;
    public final RenderSettings renderSettings = new RenderSettings();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Set<String> nonExistsTemplates = new HashSet<String>();
    private NonExistsTemplatesChecker nonExistsTemplatesChecker = null;
    private final Map<String, ITemplate> _templates = new HashMap<String, ITemplate>();
    private final Set<String> _nonTmpls = new HashSet<String>();
    private Set<String> _nonExistsTags = new HashSet<String>();
    private Map<TemplateClass, Set<TemplateClass>> extendMap = new HashMap<TemplateClass, Set<TemplateClass>>();
    private SandboxExecutingService _secureExecutor = null;
    private IEventDispatcher eventDispatcher = null;
    private static final InheritableThreadLocal<OutputMode> outputMode = new InheritableThreadLocal<OutputMode>(){

        @Override
        protected OutputMode initialValue() {
            return OutputMode.str;
        }
    };
    private IShutdownListener shutdownListener = null;

    public static void set(RythmEngine engine) {
        _engine.set(engine);
    }

    public static RythmEngine get() {
        return (RythmEngine)_engine.get();
    }

    public static boolean insideSandbox() {
        return Sandbox.sandboxMode();
    }

    public String toString() {
        return null == this._conf ? "rythm-engine-uninitialized" : this.id();
    }

    public RythmConfiguration conf() {
        if (null == this._conf) {
            throw new IllegalStateException("Rythm engine not initialized");
        }
        return this._conf;
    }

    public String version() {
        return version + "-" + this.conf().pluginVersion();
    }

    public Rythm.Mode mode() {
        if (null == this._mode) {
            this._mode = (Rythm.Mode)((Object)this.conf().get(RythmConfigurationKey.ENGINE_MODE));
        }
        return this._mode;
    }

    public String id() {
        if (null == this._id) {
            this._id = (String)this.conf().get(RythmConfigurationKey.ENGINE_ID);
        }
        return this._id;
    }

    public boolean isSingleton() {
        return Rythm.engine == this;
    }

    public boolean isProdMode() {
        return this.mode() == Rythm.Mode.prod;
    }

    public boolean isDevMode() {
        return this.mode() != Rythm.Mode.prod;
    }

    public TemplateResourceManager resourceManager() {
        return this._resourceManager;
    }

    public TemplateClassManager classes() {
        return this._classes;
    }

    public TemplateClassLoader classLoader() {
        return this._classLoader;
    }

    public TemplateClassCache classCache() {
        return this._classCache;
    }

    public ExtensionManager extensionManager() {
        return this._extensionManager;
    }

    public DialectManager dialectManager() {
        return this._dialectManager;
    }

    public final RythmEngine prepare(ICodeType codeType, Locale locale, Map<String, Object> usrCtx) {
        this.renderSettings.init(codeType).init(locale).init(usrCtx);
        return this;
    }

    public final RythmEngine prepare(ICodeType codeType) {
        this.renderSettings.init(codeType);
        return this;
    }

    public final RythmEngine prepare(Locale locale) {
        this.renderSettings.init(locale);
        return this;
    }

    public final RythmEngine prepare(Map<String, Object> userContext) {
        this.renderSettings.init(userContext);
        return this;
    }

    private void _initLogger(Map<String, ?> conf) {
        boolean logEnabled = (Boolean)RythmConfigurationKey.LOG_ENABLED.getConfiguration(conf);
        if (logEnabled) {
            ILoggerFactory factory = (ILoggerFactory)RythmConfigurationKey.LOG_FACTORY_IMPL.getConfiguration(conf);
            Logger.registerLoggerFactory(factory);
        } else {
            Logger.registerLoggerFactory(new NullLogger.Factory());
        }
    }

    private Map<String, Object> _processConf(Map<String, ?> conf) {
        HashMap<String, Object> m = new HashMap<String, Object>(conf.size());
        for (String s : conf.keySet()) {
            Object o = conf.get(s);
            if (s.startsWith("rythm.")) {
                s = s.replaceFirst("rythm\\.", "");
            }
            m.put(s, o);
        }
        return m;
    }

    private void _initConf(Map<String, ?> conf, File confFile) {
        Map<String, Object> rawConf = this._loadConfFromDisk(confFile);
        rawConf = this._processConf(rawConf);
        Properties sysProps = System.getProperties();
        rawConf.putAll(sysProps);
        if (null != conf) {
            rawConf.putAll(this._processConf(conf));
        }
        this._initLogger(rawConf);
        this._conf = new RythmConfiguration(rawConf);
        if (rawConf.containsKey("rythm.debug_conf") && Boolean.parseBoolean(rawConf.get("rythm.debug_conf").toString())) {
            this._conf.debug();
        }
    }

    public RythmEngine() {
        this.init(null, null);
    }

    public RythmEngine(File file) {
        this.init(null, file);
    }

    public RythmEngine(Properties userConfiguration) {
        this((Map<String, ?>)userConfiguration);
    }

    public RythmEngine(Map<String, ?> userConfiguration) {
        this.init(userConfiguration, null);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map _loadConfFromDisk(File conf) {
        InputStream is;
        block18: {
            is = null;
            boolean emptyConf = false;
            if (null == conf) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (null == cl) {
                    cl = Rythm.class.getClassLoader();
                }
                is = cl.getResourceAsStream("rythm.conf");
            } else {
                try {
                    is = new FileInputStream(conf);
                }
                catch (IOException e) {
                    if (emptyConf) break block18;
                    logger.warn(e, "Error opening conf file:" + conf, new Object[0]);
                }
            }
        }
        if (null != is) {
            Properties p = new Properties();
            try {
                p.load(is);
                Properties properties = p;
                return properties;
            }
            catch (Exception e) {
                logger.warn(e, "Error loading rythm.conf", new Object[0]);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return new HashMap();
    }

    private void init(Map<String, ?> conf, File file) {
        boolean enableBuiltInTemplateLang;
        if (null == file || file.isDirectory()) {
            this._initConf(conf, null);
            if (null != file) {
                this._conf.setTemplateHome(file);
            }
        } else if (file.isFile() && file.canRead()) {
            this._initConf(conf, file);
        }
        this._mode = (Rythm.Mode)((Object)this._conf.get(RythmConfigurationKey.ENGINE_MODE));
        this._classes = new TemplateClassManager(this);
        this._classLoader = new TemplateClassLoader(this);
        this._classCache = new TemplateClassCache(this);
        this._resourceManager = new TemplateResourceManager(this);
        this._extensionManager = new ExtensionManager(this);
        int ttl = (Integer)this._conf.get(RythmConfigurationKey.DEFAULT_CACHE_TTL);
        this._cacheService = (ICacheService)this._conf.get(RythmConfigurationKey.CACHE_SERVICE_IMPL);
        this._cacheService.setDefaultTTL(ttl);
        this._cacheService.startup();
        boolean enableBuiltInJavaExtensions = (Boolean)this._conf.get(RythmConfigurationKey.BUILT_IN_TRANSFORMER_ENABLED);
        if (enableBuiltInJavaExtensions) {
            this.registerTransformer("rythm", "(org.rythmengine.utils.S|s\\(\\))", S.class);
        }
        if (enableBuiltInTemplateLang = ((Boolean)this._conf.get(RythmConfigurationKey.BUILT_IN_CODE_TYPE_ENABLED)).booleanValue()) {
            ExtensionManager em = this.extensionManager();
            em.registerCodeType(ICodeType.DefImpl.HTML);
            em.registerCodeType(ICodeType.DefImpl.JS);
            em.registerCodeType(ICodeType.DefImpl.JSON);
            em.registerCodeType(ICodeType.DefImpl.CSV);
            em.registerCodeType(ICodeType.DefImpl.CSS);
        }
        this._templates.clear();
        this._templates.put("chain", new JavaTagBase(){

            @Override
            protected void call(ITag.__ParameterList params, ITag.__Body body) {
                body.render(this.__getBuffer(), new Object[0]);
            }
        });
        Object o = this._conf.get(RythmConfigurationKey.TRANSFORMER_UDT);
        if (null != o) {
            ArrayList udts = new ArrayList();
            if (o.getClass().isArray()) {
                int len = Array.getLength(o);
                for (int i = 0; i < len; ++i) {
                    Object e = Array.get(o, i);
                    if (e instanceof Class) {
                        udts.add((Class)e);
                        continue;
                    }
                    if (null == e) continue;
                    String s = e.toString();
                    try {
                        udts.add(Class.forName(s));
                        continue;
                    }
                    catch (ClassNotFoundException ce) {
                        logger.warn("User defined transformer class not found: %s", s);
                    }
                }
            } else if (o instanceof List) {
                List l = (List)o;
                for (Object e : l) {
                    if (e instanceof Class) {
                        udts.add((Class)e);
                        continue;
                    }
                    if (null == e) continue;
                    String s = e.toString();
                    try {
                        udts.add(Class.forName(s));
                    }
                    catch (ClassNotFoundException ce) {
                        logger.warn("User defined transformer class not found: %s", s);
                    }
                }
            } else if (o instanceof Class) {
                udts.add((Class)o);
            } else {
                String s = o.toString();
                for (String tc : s.split("[, \t]+")) {
                    try {
                        Class<?> c = Class.forName(tc);
                        udts.add(c);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("User defined transformer class not found: %s", tc);
                    }
                }
            }
            this.registerTransformer(udts.toArray(new Class[0]));
        }
        if (this.isDevMode()) {
            this.resourceManager().scan(this.conf().templateHome());
        }
        logger.debug("Rythm-%s started in %s mode", new Object[]{version, this.mode()});
    }

    public void registerTransformer(Class<?> ... transformerClasses) {
        this.registerTransformer((String)null, (String)null, transformerClasses);
    }

    public void registerTransformer(String namespace, String waivePattern, Class<?> ... transformerClasses) {
        ExtensionManager jem = this.extensionManager();
        for (Class<?> extensionClass : transformerClasses) {
            Transformer t = extensionClass.getAnnotation(Transformer.class);
            boolean classAnnotated = null != t;
            String nmsp = namespace;
            boolean namespaceIsEmpty = S.empty(namespace);
            if (classAnnotated && namespaceIsEmpty) {
                nmsp = t.value();
            }
            String waive = waivePattern;
            boolean waiveIsEmpty = S.empty(waive);
            if (classAnnotated && waiveIsEmpty) {
                waive = t.waivePattern();
            }
            boolean clsRequireTemplate = null == t ? false : t.requireTemplate();
            for (Method m : extensionClass.getDeclaredMethods()) {
                boolean methodAnnotated;
                int len;
                int flag = m.getModifiers();
                if (!Modifier.isPublic(flag) || !Modifier.isStatic(flag) || (len = m.getParameterTypes().length) <= 0) continue;
                Transformer tm = m.getAnnotation(Transformer.class);
                boolean bl = methodAnnotated = null != tm;
                if (!methodAnnotated && !classAnnotated) continue;
                String mnmsp = nmsp;
                if (methodAnnotated && namespaceIsEmpty && S.empty(mnmsp = tm.value())) {
                    mnmsp = nmsp;
                }
                String mwaive = waive;
                if (methodAnnotated && waiveIsEmpty && S.empty(mwaive = tm.waivePattern())) {
                    mwaive = waive;
                }
                String cn = extensionClass.getSimpleName();
                if (S.empty(mwaive)) {
                    mwaive = cn;
                }
                boolean requireTemplate = clsRequireTemplate;
                if (null != tm && tm.requireTemplate()) {
                    requireTemplate = true;
                }
                String cn0 = extensionClass.getName();
                String mn = m.getName();
                String fullName = String.format("%s.%s", cn0, mn);
                if (S.notEmpty(mnmsp) && !"rythm".equals(mnmsp)) {
                    mn = mnmsp + "_" + mn;
                }
                if (len == 1) {
                    jem.registerJavaExtension(new IJavaExtension.VoidParameterExtension(mwaive, mn, fullName, requireTemplate));
                    continue;
                }
                jem.registerJavaExtension(new IJavaExtension.ParameterExtension(mwaive, mn, ".+", fullName, requireTemplate));
            }
        }
    }

    private void setRenderArgs(ITemplate t, Object ... args) {
        if (null == args) {
            t.__setRenderArg(0, null);
        } else if (1 == args.length) {
            Object o0 = args[0];
            if (o0 instanceof Map) {
                t.__setRenderArgs((Map)args[0]);
            } else if (o0 instanceof JSONWrapper) {
                t.__setRenderArg((JSONWrapper)o0);
            } else {
                t.__setRenderArgs(args);
            }
        } else {
            t.__setRenderArgs(args);
        }
    }

    @Deprecated
    private void handleCCE(ClassCastException ce) {
    }

    private ITemplate getTemplate(IDialect dialect, String template, Object ... args) {
        TemplateClass tc;
        RythmEngine.set(this);
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        String key = template;
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(key))) {
            tc = new TemplateClass(template, this, dialect);
        }
        ITemplate t = tc.asTemplate();
        String fullTagName = this.resourceManager().getFullTagName(tc);
        tc.setFullName(fullTagName);
        this._templates.put(fullTagName, t);
        this.setRenderArgs(t, args);
        return t;
    }

    public ITemplate getTemplate(String template, Object ... args) {
        return this.getTemplate(null, template, args);
    }

    public TemplateClass getTemplateClass(ITemplateResource resource) {
        String key = S.str(resource.getKey());
        TemplateClass tc = this.classes().getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass(resource, this);
        }
        return tc;
    }

    public ITemplate getTemplate(File file, Object ... args) {
        ITemplate t;
        TemplateClass tc;
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        String key = S.str(this.resourceManager().get(file).getKey());
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(key))) {
            tc = new TemplateClass(file, this);
            t = tc.asTemplate();
            if (null == t) {
                return null;
            }
            String fullTagName = this.resourceManager().getFullTagName(tc);
            tc.setFullName(fullTagName);
            this._templates.put(fullTagName, t);
        } else {
            t = tc.asTemplate();
        }
        this.setRenderArgs(t, args);
        return t;
    }

    public String render(String template, Object ... args) {
        ITemplate t = this.getTemplate(template, args);
        return t.render();
    }

    public void render(OutputStream os, String template, Object ... args) {
        outputMode.set(OutputMode.os);
        ITemplate t = this.getTemplate(template, args);
        t.render(os);
    }

    public void render(Writer w, String template, Object ... args) {
        outputMode.set(OutputMode.writer);
        ITemplate t = this.getTemplate(template, args);
        t.render(w);
    }

    public String render(File file, Object ... args) {
        ITemplate t = this.getTemplate(file, args);
        return t.render();
    }

    public void render(OutputStream os, File file, Object ... args) {
        outputMode.set(OutputMode.os);
        ITemplate t = this.getTemplate(file, args);
        t.render(os);
    }

    public void render(Writer w, File file, Object ... args) {
        outputMode.set(OutputMode.writer);
        ITemplate t = this.getTemplate(file, args);
        t.render(w);
    }

    public String renderStr(String template, Object ... args) {
        return this.renderString(template, args);
    }

    public String renderString(String template, Object ... args) {
        TemplateClass tc;
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        String key = template;
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(key, false))) {
            tc = new TemplateClass(new StringTemplateResource(template), this);
        }
        ITemplate t = tc.asTemplate();
        this.setRenderArgs(t, args);
        return t.render();
    }

    public String substitute(String template, Object ... args) {
        ITemplate t = this.getTemplate(BasicRythm.INSTANCE, template, args);
        return t.render();
    }

    public String substitute(File file, Object ... args) {
        ITemplate t = this.getTemplate(file, args, BasicRythm.INSTANCE);
        return t.render();
    }

    public String toString(String template, Object obj) {
        Class<?> argClass = obj.getClass();
        String clsName = argClass.getName();
        if (clsName.matches(".*\\$[0-9].*")) {
            argClass = obj.getClass().getSuperclass();
        }
        String key = template + argClass;
        TemplateClass tc = this.classes().getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass(template, this, (IDialect)new ToString(argClass));
        }
        ITemplate t = tc.asTemplate();
        t.__setRenderArg(0, obj);
        return t.render();
    }

    public String toString(Object obj) {
        return this.toString(obj, ToStringOption.DEFAULT_OPTION, null);
    }

    public String toString(Object obj, ToStringOption option, ToStringStyle style) {
        Class<?> c = obj.getClass();
        AutoToString.AutoToStringData key = new AutoToString.AutoToStringData(c, option, style);
        TemplateClass tc = this.classes().getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass((ITemplateResource)new ToStringTemplateResource(key), this, (IDialect)new AutoToString(c, key));
        }
        ITemplate t = tc.asTemplate();
        t.__setRenderArg(0, obj);
        return t.render();
    }

    public String commonsToString(Object obj, ToStringOption option, org.apache.commons.lang3.builder.ToStringStyle style) {
        return this.toString(obj, option, ToStringStyle.fromApacheStyle(style));
    }

    public String renderIfTemplateExists(String template, Object ... args) {
        TemplateClass tc;
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        if (this.nonExistsTemplates.contains(template)) {
            return "";
        }
        String key = template;
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(template))) {
            ITemplateResource rsrc = this.resourceManager().getResource(template);
            if (rsrc.isValid()) {
                tc = new TemplateClass(rsrc, this);
            } else {
                this.nonExistsTemplates.add(template);
                if (this.mode().isDev() && this.nonExistsTemplatesChecker == null) {
                    this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                }
                return "";
            }
        }
        ITemplate t = tc.asTemplate();
        this.setRenderArgs(t, args);
        return t.render();
    }

    public Object eval(String script) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine jsEngine = manager.getEngineByName("JavaScript");
        try {
            return jsEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean templateRegistered(String tmplName) {
        return this._templates.containsKey(tmplName);
    }

    public ITemplate getRegisteredTemplate(String tmplName) {
        return this._templates.get(tmplName);
    }

    public TemplateClass getRegisteredTemplateClass(String name) {
        TemplateBase tmpl = (TemplateBase)this._templates.get(name);
        if (null == tmpl) {
            return null;
        }
        return tmpl.__getTemplateClass(false);
    }

    public RythmEngine registerTemplateClass(TemplateClass tc) {
        String fullName = this.resourceManager().getFullTagName(tc);
        tc.setFullName(fullName);
        this.classes().add(tc);
        return this;
    }

    public String testTemplate(String name, TemplateClass callerClass) {
        String callerName;
        int pos;
        if (Keyword.THIS.toString().equals(name)) {
            return this.resourceManager().getFullTagName(callerClass);
        }
        if (this.mode().isProd() && this._nonTmpls.contains(name)) {
            return null;
        }
        if (this.templateRegistered(name)) {
            return name;
        }
        if (null != callerClass.importPaths) {
            for (String s : callerClass.importPaths) {
                String name0 = s + "." + name;
                if (!this._templates.containsKey(name0)) continue;
                return name0;
            }
        }
        if (-1 != (pos = (callerName = this.resourceManager().getFullTagName(callerClass)).lastIndexOf("."))) {
            String s = callerName.substring(0, pos);
            String name0 = s + "." + name;
            if (this._templates.containsKey(name0)) {
                return name0;
            }
            pos = s.lastIndexOf(".");
            if (-1 != pos && this._templates.containsKey(name0 = (s = callerName.substring(0, pos)) + "." + name)) {
                return name0;
            }
        }
        try {
            TemplateClass tc = this.resourceManager().tryLoadTemplate(name, callerClass);
            if (null == tc) {
                if (this.mode().isProd()) {
                    this._nonTmpls.add(name);
                }
                return null;
            }
            String fullName = tc.getFullName();
            return fullName;
        }
        catch (TagLoadException e) {
            throw e;
        }
        catch (RythmException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e, "error trying load tag[%s]", name);
            return null;
        }
    }

    public boolean registerTemplate(ITemplate template) {
        String name = template instanceof JavaTagBase ? template.__getName() : template.__getTemplateClass(false).getFullName();
        return this.registerTemplate(name, template);
    }

    public boolean registerTemplate(String name, ITemplate template) {
        if (null == template) {
            throw new NullPointerException();
        }
        if (this._templates.containsKey(name)) {
            return false;
        }
        this._templates.put(name, template);
        logger.trace("tag %s registered", name);
        return true;
    }

    public void invokeTemplate(int line, String name, ITemplate caller, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context) {
        this.invokeTemplate(line, name, caller, params, body, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTemplate(int line, String name, ITemplate caller, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context, boolean ignoreNonExistsTag) {
        if (this._nonExistsTags.contains(name)) {
            return;
        }
        ITemplate t = this._templates.get(name);
        TemplateClass tc = caller.__getTemplateClass(true);
        if (null == t && S.isEqual(name, caller.__getName())) {
            t = caller;
        }
        if (null == t) {
            String callerName;
            int pos;
            String name0;
            if (null != tc.importPaths) {
                String s;
                Iterator<String> i$ = tc.importPaths.iterator();
                while (i$.hasNext() && null == (t = this._templates.get(name0 = (s = i$.next()) + "." + name))) {
                }
            }
            if (null == t && -1 != (pos = (callerName = this.resourceManager().getFullTagName(tc)).lastIndexOf("."))) {
                name0 = callerName.substring(0, pos) + "." + name;
                t = this._templates.get(name0);
            }
            if (null == t) {
                tc = this.resourceManager().tryLoadTemplate(name, tc);
                if (null != tc) {
                    t = this._templates.get(tc.getFullName());
                }
                if (null == t) {
                    if (ignoreNonExistsTag) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("cannot find tag: " + name, new Object[0]);
                        }
                        this._nonExistsTags.add(name);
                        if (this.mode().isDev() && this.nonExistsTemplatesChecker == null) {
                            this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                        }
                        return;
                    }
                    throw new NullPointerException("cannot find tag: " + name);
                }
                t = t.__cloneMe(this, caller);
            }
        }
        if (!(t instanceof JavaTagBase)) {
            String cn = t.getClass().getName();
            TemplateClass tc0 = this.classes().getByClassName(cn);
            if (null == tc0) {
                System.out.println(t.getClass());
                System.out.println(name);
                System.out.println(cn);
                System.out.println(caller.getClass());
            }
            t = tc0.asTemplate(caller);
        } else {
            t = t.__cloneMe(this, caller);
        }
        if (null != params) {
            if (t instanceof JavaTagBase) {
                ((JavaTagBase)t).__setRenderArgs0(params);
            } else {
                for (int i = 0; i < params.size(); ++i) {
                    ITag.__Parameter param = params.get(i);
                    if (null != param.name) {
                        t.__setRenderArg(param.name, param.value);
                        continue;
                    }
                    t.__setRenderArg(i, param.value);
                }
            }
        }
        if (null == body && null != params && null == (body = (ITag.__Body)params.getByName("__body"))) {
            body = (ITag.__Body)params.getByName("_body");
        }
        if (null != body) {
            t.__setRenderArg("__body", (Object)body);
            t.__setRenderArg("_body", (Object)body);
        }
        RythmEvents.ON_TAG_INVOCATION.trigger(this, F.T2((TemplateBase)caller, t));
        try {
            if (null != context) {
                t.__setBodyContext(context);
            }
            t.__call(line);
        }
        finally {
            RythmEvents.TAG_INVOKED.trigger(this, F.T2((TemplateBase)caller, t));
        }
    }

    public void cache(String key, Object o, int ttl, Object ... args) {
        String value;
        if (this.conf().cacheDisabled()) {
            return;
        }
        ICacheService cacheService = this._cacheService;
        String string = null == o ? "" : (value = o instanceof Serializable ? (Serializable)o : o.toString());
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        cacheService.put(key, (Serializable)((Object)value), ttl);
    }

    public void cache(String key, Object o, String duration, Object ... args) {
        if (this.conf().cacheDisabled()) {
            return;
        }
        IDurationParser dp = this.conf().durationParser();
        int ttl = null == duration ? 0 : dp.parseDuration(duration);
        this.cache(key, o, ttl, args);
    }

    public Serializable cached(String key, Object ... args) {
        if (this.conf().cacheDisabled()) {
            return null;
        }
        ICacheService cacheService = this._cacheService;
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        return cacheService.get(key);
    }

    public void addExtendRelationship(TemplateClass parent, TemplateClass child) {
        if (this.mode().isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            children = new HashSet<TemplateClass>();
            this.extendMap.put(parent, children);
        }
        children.add(child);
    }

    public void invalidate(TemplateClass parent) {
        if (this.mode().isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            return;
        }
        for (TemplateClass child : children) {
            this.invalidate(child);
            child.reset();
        }
    }

    private SandboxExecutingService secureExecutor() {
        if (null == this._secureExecutor) {
            int poolSize = (Integer)this.conf().get(RythmConfigurationKey.SANDBOX_POOL_SIZE);
            SecurityManager sm = (SecurityManager)this.conf().get(RythmConfigurationKey.SANDBOX_SECURITY_MANAGER_IMPL);
            int timeout = (Integer)this.conf().get(RythmConfigurationKey.SANDBOX_TIMEOUT);
            SandboxThreadFactory fact = (SandboxThreadFactory)this.conf().get(RythmConfigurationKey.SANBOX_THREAD_FACTORY_IMPL);
            if (null == fact) {
                fact = new SandboxThreadFactory(sm, null, this);
            }
            this._secureExecutor = new SandboxExecutingService(poolSize, fact, timeout, this);
        }
        return this._secureExecutor;
    }

    public Sandbox sandbox() {
        return new Sandbox(this, this.secureExecutor());
    }

    public Sandbox sandbox(Map<String, Object> context) {
        return new Sandbox(this, this.secureExecutor()).setUserContext(context);
    }

    private IEventDispatcher eventDispatcher() {
        if (null == this.eventDispatcher) {
            this.eventDispatcher = new EventBus(this);
        }
        return this.eventDispatcher;
    }

    @Override
    public Object accept(IEvent event, Object param) {
        return this.eventDispatcher().accept(event, param);
    }

    public static OutputMode outputMode() {
        return (OutputMode)((Object)outputMode.get());
    }

    public void restart(RuntimeException cause) {
        if (this.isProdMode()) {
            throw cause;
        }
        if (!(cause instanceof ClassReloadException)) {
            String msg = cause.getMessage();
            if (cause instanceof RythmException) {
                RythmException re = (RythmException)cause;
                msg = re.getSimpleMessage();
            }
            logger.warn("restarting rythm engine due to %s", msg);
        }
        this.restart();
    }

    private void restart() {
        if (this.isProdMode()) {
            return;
        }
        this._classLoader = new TemplateClassLoader(this);
        ArrayList<String> templateTags = new ArrayList<String>();
        for (String name : this._templates.keySet()) {
            ITag tag = this._templates.get(name);
            if (tag instanceof JavaTagBase) continue;
            templateTags.add(name);
        }
        for (String name : templateTags) {
            this._templates.remove(name);
        }
    }

    void setShutdownListener(IShutdownListener listener) {
        this.shutdownListener = listener;
    }

    public void shutdown() {
        if (null != this._cacheService) {
            try {
                this._cacheService.shutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error shutdown cache service", new Object[0]);
            }
        }
        if (null != this._secureExecutor) {
            try {
                this._secureExecutor.shutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error shutdown secure executor", new Object[0]);
            }
        }
        if (null != this.shutdownListener) {
            try {
                this.shutdownListener.onShutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error execute shutdown listener", new Object[0]);
            }
        }
        if (null != this._templates) {
            this._templates.clear();
        }
        if (null != this._classes) {
            this._classes.clear();
        }
        if (null != this._nonExistsTags) {
            this._nonExistsTags.clear();
        }
        if (null != this._nonTmpls) {
            this._nonTmpls.clear();
        }
    }

    static interface IShutdownListener {
        public void onShutdown();
    }

    public static enum OutputMode {
        os,
        writer,
        str{

            @Override
            public boolean writeOutput() {
                return false;
            }
        };


        public boolean writeOutput() {
            return true;
        }
    }

    private class NonExistsTemplatesChecker {
        boolean started = false;
        private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);

        NonExistsTemplatesChecker() {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> toBeRemoved = new ArrayList<String>();
                    for (String template : RythmEngine.this.nonExistsTemplates) {
                        ITemplateResource rsrc = RythmEngine.this.resourceManager().getResource(template);
                        if (!rsrc.isValid()) continue;
                        toBeRemoved.add(template);
                    }
                    RythmEngine.this.nonExistsTemplates.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                    TemplateClass tc = RythmEngine.this.classes().all().get(0);
                    for (String tag : RythmEngine.this._nonExistsTags) {
                        if (null == RythmEngine.this.resourceManager().tryLoadTemplate(tag, tc)) continue;
                        toBeRemoved.add(tag);
                    }
                    RythmEngine.this._nonExistsTags.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                }
            }, 0L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    public class RenderSettings {
        private final ThreadLocal<Locale> _locale = new ThreadLocal<Locale>(){

            @Override
            protected Locale initialValue() {
                return RythmEngine.this.conf().locale();
            }
        };
        private final ThreadLocal<ICodeType> _codeType = new ThreadLocal<ICodeType>(){

            @Override
            protected ICodeType initialValue() {
                return null;
            }
        };
        private final ThreadLocal<Map<String, Object>> _usrCtx = new ThreadLocal();

        public final RenderSettings init(ICodeType codeType) {
            if (null != codeType) {
                this._codeType.set(codeType);
            } else {
                this._codeType.remove();
            }
            return this;
        }

        public final RenderSettings init(Locale locale) {
            if (null != locale) {
                this._locale.set(locale);
            } else {
                this._locale.remove();
            }
            return this;
        }

        public final RenderSettings init(Map<String, Object> usrCtx) {
            if (null != usrCtx) {
                this._usrCtx.set(usrCtx);
            } else {
                this._usrCtx.remove();
            }
            return this;
        }

        public final Locale locale() {
            return this._locale.get();
        }

        public final ICodeType codeType() {
            return this._codeType.get();
        }

        public final Map<String, Object> userContext() {
            return this._usrCtx.get();
        }

        public final RythmEngine clear() {
            this._locale.remove();
            this._codeType.remove();
            this._usrCtx.remove();
            return RythmEngine.this;
        }
    }
}

