/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.transport.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jflux.api.core.Listener;

public class JMSMessageSender
implements Listener<BytesMessage> {
    private static final Logger theLogger = Logger.getLogger(JMSMessageSender.class.getName());
    private Session mySession;
    private Destination myDestination;
    private MessageProducer myProducer;

    public JMSMessageSender(Session session, Destination dest) {
        this.mySession = session;
        this.myDestination = dest;
        this.start();
    }

    public void setSession(Session session) {
        this.stop();
        this.mySession = session;
        this.start();
    }

    public void setDestination(Destination dest) {
        this.stop();
        this.myDestination = dest;
        this.start();
    }

    private void start() {
        try {
            if (this.mySession == null || this.myDestination == null) {
                return;
            }
            if (this.myProducer != null) {
                return;
            }
            this.myProducer = this.mySession.createProducer(this.myDestination);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to create producer.", ex);
            return;
        }
    }

    private void stop() {
        try {
            if (this.myProducer == null) {
                return;
            }
            this.myProducer.close();
            this.myProducer = null;
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to close producer.", ex);
            return;
        }
    }

    public void handleEvent(BytesMessage event) {
        if (this.myProducer == null) {
            return;
        }
        try {
            this.myProducer.send((Message)event);
        }
        catch (JMSException ex) {
            theLogger.log(Level.INFO, "Unable to send event.", ex);
        }
    }
}

