/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.transport.jms;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.node.DefaultProducerNode;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.util.DefaultNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageReceiver
extends DefaultProducerNode<BytesMessage> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSMessageReceiver.class);
    private Session mySession;
    private Destination myDestination;
    private MessageConsumer myMessageConsumer;
    private Thread myPollingThread;

    public JMSMessageReceiver(Session session, Destination dest) {
        super((Notifier)new DefaultNotifier());
        if (session == null || dest == null) {
            throw new NullPointerException();
        }
        this.mySession = session;
        this.myDestination = dest;
        this.createConsumer();
    }

    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.myPollingThread != null && this.myPollingThread.isAlive()) {
            return true;
        }
        this.myPollingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JMSMessageReceiver.this.eventLoop();
            }
        });
        this.myPollingThread.start();
        return true;
    }

    public void setDestination(Destination dest) {
        this.closeConsumer();
        this.myDestination = dest;
        this.createConsumer();
    }

    public void setSession(Session session) {
        this.closeConsumer();
        this.mySession = session;
        this.createConsumer();
    }

    private void createConsumer() {
        if (this.mySession == null || this.myDestination == null) {
            return;
        }
        try {
            this.myMessageConsumer = this.mySession.createConsumer(this.myDestination);
        }
        catch (JMSException ex) {
            theLogger.warn("Unable to create JMS Consumer.", (Throwable)ex);
        }
    }

    private void closeConsumer() {
        if (this.myMessageConsumer == null) {
            return;
        }
        try {
            this.myMessageConsumer.close();
        }
        catch (JMSException ex) {
            theLogger.warn("Error closeing JMS Consumer.", (Throwable)ex);
        }
        this.myMessageConsumer = null;
    }

    private void eventLoop() {
        while (this.getPlayState() == Playable.PlayState.RUNNING || this.getPlayState() == Playable.PlayState.PAUSED) {
            if (this.getPlayState() == Playable.PlayState.PAUSED) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            try {
                BytesMessage bytesMsg = this.fetchMessage();
                if (bytesMsg == null || this.getPlayState() != Playable.PlayState.RUNNING) continue;
                this.getNotifier().notifyListeners((Object)bytesMsg);
            }
            catch (Throwable t) {
                theLogger.warn("Error in Message fetch loop.", t);
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private BytesMessage fetchMessage() {
        try {
            if (this.myMessageConsumer == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                return null;
            }
            Message msg = this.myMessageConsumer.receive();
            if (msg == null) {
                theLogger.info("Received Null message.");
                return null;
            }
            msg.acknowledge();
            if (!(msg instanceof BytesMessage)) {
                theLogger.warn("Received JMS Message not of type BytesMessage.  Ignoring Message.");
                return null;
            }
            return (BytesMessage)msg;
        }
        catch (JMSException ex) {
            theLogger.error("Error fetching Message.", (Throwable)ex);
            return null;
        }
    }
}

