/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.transport.jms;

import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.url.URLSyntaxException;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;

public class ConnectionConfigUtils {
    private static final Logger theLogger = Logger.getLogger(ConnectionConfigUtils.class.getName());
    private static final String theAMQPFormatString = "amqp://%s:%s@%s/%s?brokerlist='%s'";
    public static final String CONF_BROKER_IP = "msgBrokerIp";
    public static final String CONF_BROKER_PORT = "msgBrokerPort";
    public static final String CONF_BROKER_USERNAME = "msgBrokerUser";
    public static final String CONF_BROKER_PASSWORD = "msgBrokerPassword";
    public static final String CONF_BROKER_CLIENT_NAME = "msgBrokerClientName";
    public static final String CONF_BROKER_VIRTUAL_HOST = "msgBrokerVirtualHost";
    public static final String DEF_BROKER_IP = "127.0.0.1";
    public static final String DEF_BROKER_PORT = "5672";
    public static final String DEF_BROKER_USERNAME = "admin";
    public static final String DEF_BROKER_PASSWORD = "admin";
    public static final String DEF_BROKER_CLIENT_NAME = "client1";
    public static final String DEF_BROKER_VIRTUAL_HOST = "test";
    public static final String CONF_DESTINATION_NAME = "msgDestinationName";
    public static final String CONF_DESTINATION_CREATE = "msgDestinationCreateMode";
    public static final String CONF_DESTINATION_NODE_TYPE = "msgDestinationNodeType";
    public static final String CONF_DESTINATION_NODE_OPTIONS = "msgDestinationNodeOpts";
    public static final String CONF_DESTINATION_OPTIONS = "msgDestinationOpts";
    public static final String CREATE_ALWAYS = "always";
    public static final String CREATE_NEVER = "never";
    public static final String CREATE_SENDER = "sender";
    public static final String CREATE_RECEIVER = "receiver";
    public static final String NODE_QUEUE = "queue";
    public static final String NODE_TOPIC = "topic";
    public static final String NODE_UNKNOWN = "unknown";
    public static final String DEF_DESTINATION_CREATE = "never";
    public static final String DEF_DESTINATION_NODE_TYPE = "unknown";

    public static Configuration<String> buildConnectionConfig() {
        DefaultConfiguration conf = new DefaultConfiguration();
        conf.addProperty(String.class, (Object)CONF_BROKER_IP, (Object)DEF_BROKER_IP);
        conf.addProperty(String.class, (Object)CONF_BROKER_PORT, (Object)DEF_BROKER_PORT);
        conf.addProperty(String.class, (Object)CONF_BROKER_USERNAME, (Object)"admin");
        conf.addProperty(String.class, (Object)CONF_BROKER_PASSWORD, (Object)"admin");
        conf.addProperty(String.class, (Object)CONF_BROKER_CLIENT_NAME, (Object)DEF_BROKER_CLIENT_NAME);
        conf.addProperty(String.class, (Object)CONF_BROKER_VIRTUAL_HOST, (Object)DEF_BROKER_VIRTUAL_HOST);
        return conf;
    }

    public static Configuration<String> buildConnectionConfig(String ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        Configuration<String> conf = ConnectionConfigUtils.buildConnectionConfig();
        if (ip != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_IP, ip);
        }
        return conf;
    }

    public static Configuration<String> buildConnectionConfig(String ip, String port, String username, String password, String clientName, String virtualHost) {
        Configuration<String> conf = ConnectionConfigUtils.buildConnectionConfig(ip);
        if (port != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_PORT, port);
        }
        if (username != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_USERNAME, username);
        }
        if (password != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_PASSWORD, password);
        }
        if (clientName != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_CLIENT_NAME, clientName);
        }
        if (virtualHost != null) {
            ConnectionConfigUtils.set(conf, CONF_BROKER_VIRTUAL_HOST, virtualHost);
        }
        return conf;
    }

    public static Configuration<String> buildDestinationConfig(String name) {
        DefaultConfiguration conf = new DefaultConfiguration();
        conf.addProperty(String.class, (Object)CONF_DESTINATION_NAME, (Object)name);
        conf.addProperty(String.class, (Object)CONF_DESTINATION_NODE_TYPE, (Object)"unknown");
        conf.addProperty(String.class, (Object)CONF_DESTINATION_CREATE, (Object)"never");
        conf.addProperty(String.class, (Object)CONF_DESTINATION_OPTIONS, null);
        conf.addProperty(String.class, (Object)CONF_DESTINATION_NODE_OPTIONS, null);
        return conf;
    }

    public static Configuration<String> buildDestinationConfig(String name, String type) {
        Configuration<String> conf = ConnectionConfigUtils.buildDestinationConfig(name);
        if (type != null) {
            ConnectionConfigUtils.set(conf, CONF_DESTINATION_NODE_TYPE, type);
        }
        return conf;
    }

    public static Configuration<String> buildDestinationConfig(String name, String type, String create) {
        Configuration<String> conf = ConnectionConfigUtils.buildDestinationConfig(name, type);
        if (create != null) {
            ConnectionConfigUtils.set(conf, CONF_DESTINATION_CREATE, create);
        }
        return conf;
    }

    public static Configuration<String> buildDestinationConfig(String name, String type, String create, String options, String nodeOptions) {
        Configuration<String> conf = ConnectionConfigUtils.buildDestinationConfig(name, type, create);
        if (options != null) {
            ConnectionConfigUtils.set(conf, CONF_DESTINATION_OPTIONS, options);
        }
        if (nodeOptions != null) {
            ConnectionConfigUtils.set(conf, CONF_DESTINATION_NODE_OPTIONS, nodeOptions);
        }
        return conf;
    }

    static Connection createConnection(Configuration<String> conf) throws JMSException, URLSyntaxException {
        String ip = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_IP);
        String port = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_PORT);
        String username = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_USERNAME);
        String password = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_PASSWORD);
        String clientName = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_CLIENT_NAME);
        String virtualHost = (String)conf.getPropertyValue(String.class, (Object)CONF_BROKER_VIRTUAL_HOST);
        String addr = "tcp://" + ip + ":" + port;
        String amqpURL = String.format(theAMQPFormatString, username, password, clientName, virtualHost, addr);
        String reconnectOptions = "&connectdelay='5000'&retries='2147483647'";
        amqpURL = amqpURL + reconnectOptions;
        AMQConnectionFactory cf = new AMQConnectionFactory(amqpURL);
        return cf.createConnection();
    }

    static Destination createDestination(Configuration<String> conf) throws URISyntaxException {
        String destStr = (String)conf.getPropertyValue(String.class, (Object)CONF_DESTINATION_NAME);
        String type = (String)conf.getPropertyValue(String.class, (Object)CONF_DESTINATION_NODE_TYPE);
        String create = (String)conf.getPropertyValue(String.class, (Object)CONF_DESTINATION_CREATE);
        String opts = (String)conf.getPropertyValue(String.class, (Object)CONF_DESTINATION_OPTIONS);
        String nodeOpts = (String)conf.getPropertyValue(String.class, (Object)CONF_DESTINATION_NODE_OPTIONS);
        if (destStr == null) {
            throw new NullPointerException();
        }
        if (type == null || "unknown".equals(type)) {
            type = null;
            create = null;
        }
        if ((nodeOpts = ConnectionConfigUtils.addOpts(nodeOpts, "type", type)) != null && !nodeOpts.isEmpty()) {
            nodeOpts = "{" + nodeOpts + "}";
        }
        opts = ConnectionConfigUtils.addOpts(opts, "create", create);
        if ((opts = ConnectionConfigUtils.addOpts(opts, "node", nodeOpts)) != null && !opts.isEmpty()) {
            destStr = destStr + "; {" + opts + "}";
        }
        if (NODE_QUEUE.equals(type)) {
            return new AMQQueue(destStr);
        }
        if (NODE_TOPIC.equals(type)) {
            return new AMQTopic(destStr);
        }
        return new AMQAnyDestination(destStr);
    }

    private static String addOpts(String opts, String k, String v) {
        if (k == null || k.isEmpty() || v == null || v.isEmpty()) {
            return opts;
        }
        String kv = k + ":" + v;
        return opts == null || opts.isEmpty() ? kv : opts + ", " + kv;
    }

    private static void set(Configuration<String> conf, String key, String val) {
        conf.getPropertySetter(String.class, (Object)key).handleEvent((Object)val);
    }

    public static class SessionFactory
    implements Adapter<Connection, Session> {
        public Session adapt(Connection a) {
            try {
                return a.createSession(false, 2);
            }
            catch (JMSException ex) {
                theLogger.log(Level.WARNING, "Unable to create Session.", ex);
                return null;
            }
        }
    }

    public static class DestinationFactory
    implements Adapter<Configuration<String>, Destination> {
        public Destination adapt(Configuration<String> a) {
            try {
                return ConnectionConfigUtils.createDestination(a);
            }
            catch (URISyntaxException ex) {
                theLogger.log(Level.WARNING, "Unable to create destination.", ex);
                return null;
            }
        }
    }

    public static class ConnectionFactory
    implements Adapter<Configuration<String>, Connection> {
        public Connection adapt(Configuration<String> a) {
            try {
                Connection connection = ConnectionConfigUtils.createConnection(a);
                connection.start();
                return connection;
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Unable to start connection.", ex);
                return null;
            }
        }
    }
}

