/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.impl.messaging;

import java.io.ByteArrayOutputStream;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.node.chain.ConsumerChain;
import org.jflux.api.core.node.chain.NodeChainBuilder;
import org.jflux.api.core.node.chain.ProducerChain;
import org.jflux.api.encode.EncodeRequest;
import org.jflux.impl.encode.avro.AvroDecoder;
import org.jflux.impl.encode.avro.AvroEncoder;
import org.jflux.impl.transport.jms.JMSMessageReceiver;
import org.jflux.impl.transport.jms.JMSMessageSender;
import org.jflux.impl.transport.jms.MessagePacker;
import org.jflux.impl.transport.jms.MessageUnpacker;

public class JMSAvroUtils {
    public static <T, R extends IndexedRecord> ConsumerChain<EncodeRequest<T, ByteArrayOutputStream>> buildEventSenderChain(Class<R> recordClass, Schema schema, Adapter<T, R> eventAdapter, Session session, Destination dest, Adapter<BytesMessage, BytesMessage> optionalProc) throws JMSException {
        return NodeChainBuilder.build((Adapter)new EncodeRequest.InnerAdapter(eventAdapter)).attach(AvroEncoder.buildBinaryEncoder(recordClass, (Schema)schema)).getConsumerChain(JMSAvroUtils.buildJMSSenderChain(session, dest, optionalProc));
    }

    public static <R extends IndexedRecord> ConsumerChain<EncodeRequest<R, ByteArrayOutputStream>> buildJMSAvroSenderChain(Class<R> recordClass, Schema schema, Session session, Destination dest, Adapter<BytesMessage, BytesMessage> optionalProc) throws Exception {
        return NodeChainBuilder.build((Adapter)AvroEncoder.buildBinaryEncoder(ByteArrayOutputStream.class, recordClass, (Schema)schema)).getConsumerChain(JMSAvroUtils.buildJMSSenderChain(session, dest, optionalProc));
    }

    public static ConsumerChain<ByteArrayOutputStream> buildJMSSenderChain(Session session, Destination dest, Adapter<BytesMessage, BytesMessage> optionalProc) throws JMSException {
        if (optionalProc == null) {
            return NodeChainBuilder.build((Adapter)new MessagePacker(session)).getConsumerChain((Listener)new JMSMessageSender(session, dest));
        }
        return NodeChainBuilder.build((Adapter)new MessagePacker(session)).attach(optionalProc).getConsumerChain((Listener)new JMSMessageSender(session, dest));
    }

    public static <E, R extends IndexedRecord> ProducerChain<E> buildEventReceiverChain(Class<R> recordClass, Schema schema, Adapter<R, E> recordAdapter, Session session, Destination dest) throws JMSException {
        return NodeChainBuilder.build((ProducerNode)new JMSMessageReceiver(session, dest)).attach((Adapter)new MessageUnpacker()).attach((Adapter)AvroDecoder.buildBinaryDecoder(recordClass, (Schema)schema)).attach(recordAdapter).getProducerChain();
    }

    public static <T extends IndexedRecord> ProducerChain<T> buildJMSAvroReceiverChain(Class<T> recordClass, Schema schema, Session session, Destination dest) throws JMSException {
        return NodeChainBuilder.build((ProducerNode)new JMSMessageReceiver(session, dest)).attach((Adapter)new MessageUnpacker()).attach((Adapter)AvroDecoder.buildBinaryDecoder(recordClass, (Schema)schema)).getProducerChain();
    }

    public static <T> Adapter<T, EncodeRequest<T, ByteArrayOutputStream>> byteStreamRequestFactory() {
        return EncodeRequest.factory((Source)new ByteOutputStreamFactory());
    }

    public static <T> Adapter<T, EncodeRequest<T, ByteArrayOutputStream>> byteStreamRequestFactory(Class<T> clazz) {
        return EncodeRequest.factory((Source)new ByteOutputStreamFactory());
    }

    public static class ByteOutputStreamFactory
    implements Source<ByteArrayOutputStream> {
        public ByteArrayOutputStream getValue() {
            return new ByteArrayOutputStream();
        }
    }
}

