/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.interpolation.cspline;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CSplineSegment {
    private List<Point2D> myControlPoints;
    private List<Point2D> myInterpolatedPoints;
    private int mySteps;

    public CSplineSegment(List<Point2D> points) {
        if (points.size() != 4) {
            throw new IllegalArgumentException("Cardinal Splines segments require 4 control points, found " + points.size());
        }
        this.mySteps = (int)(points.get(1).distance(points.get(2)) / 8.0) + 2;
        this.mySteps = Math.min(this.mySteps, 200);
        this.myControlPoints = new ArrayList<Point2D>(points.size());
        for (Point2D p : points) {
            this.myControlPoints.add((Point2D)p.clone());
        }
        this.interpolate();
    }

    private void interpolate() {
        this.myInterpolatedPoints = new LinkedList<Point2D>();
        for (int i = 0; i < this.mySteps; ++i) {
            double t = (double)i / (double)(this.mySteps - 1);
            double[] vals = this.calcStep(t);
            this.myInterpolatedPoints.add(this.getStepPoint(vals));
        }
    }

    private double[] calcStep(double t) {
        double a = t * t * t;
        double b = t * t;
        double c = t;
        double d = 1.0;
        return new double[]{-a + 2.0 * b - c, 3.0 * a - 5.0 * b + 2.0 * d, -3.0 * a + 4.0 * b + c, a - b};
    }

    private Point2D getStepPoint(double[] vals) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < 4; ++i) {
            x += vals[i] * this.myControlPoints.get(i).getX();
            y += vals[i] * this.myControlPoints.get(i).getY();
        }
        return new Point2D.Double(x * 0.5, y * 0.5);
    }

    public List<Point2D> getInterpolatedPoints() {
        return this.myInterpolatedPoints;
    }
}

