/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.interpolation.InterpolatorDirectory;
import org.robokind.api.interpolation.bezier.BezierInterpolatorFactory;
import org.robokind.api.interpolation.cspline.CSplineInterpolatorFactory;
import org.robokind.api.interpolation.linear.LinearInterpolatorFactory;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationControl Activation Begin.");
        InterpolatorDirectory.instance().setContext(context);
        InterpolatorDirectory.registerFactory(context, new CSplineInterpolatorFactory());
        theLogger.log(Level.INFO, "CSplineInterpolatorFactory Service Registered Successfully.");
        InterpolatorDirectory.registerFactory(context, new LinearInterpolatorFactory());
        theLogger.log(Level.INFO, "LinearInterpolatorFactory Service Registered Successfully.");
        InterpolatorDirectory.registerFactory(context, new BezierInterpolatorFactory());
        theLogger.log(Level.INFO, "BezierInterpolatorFactory Service Registered Successfully.");
        theLogger.log(Level.INFO, "AnimationControl Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

