/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;

public class RemoteAnimationPlayerHost
implements Listener<AnimationSignal> {
    private static final Logger theLogger = Logger.getLogger(RemoteAnimationPlayerHost.class.getName());
    private AnimationPlayer myAnimationPlayer;
    private MessageAsyncReceiver<AnimationEvent> myAnimationReceiver;
    private Listener<AnimationEvent> myEventPlayer = new HackedEventPlayer();
    private MessageSender<AnimationSignal> mySignalSender;

    public void setAnimationPlayer(AnimationPlayer player) {
        if (this.myAnimationPlayer != null) {
            this.myAnimationPlayer.removeAnimationSignalListener(this);
        }
        this.myAnimationPlayer = player;
        if (this.myAnimationPlayer != null) {
            this.myAnimationPlayer.addAnimationSignalListener(this);
        }
    }

    public void setAnimationReceiver(MessageAsyncReceiver<AnimationEvent> receiver) {
        if (this.myAnimationReceiver != null) {
            this.myAnimationReceiver.removeListener(this.myEventPlayer);
        }
        this.myAnimationReceiver = receiver;
        if (this.myAnimationReceiver != null) {
            this.myAnimationReceiver.addListener(this.myEventPlayer);
        }
    }

    public void setSignalSender(MessageSender<AnimationSignal> sender) {
        this.mySignalSender = sender;
    }

    public void handleEvent(AnimationSignal t) {
        if (this.mySignalSender != null) {
            this.mySignalSender.notifyListeners((Object)t);
        }
    }

    public class HackedEventPlayer
    implements Listener<AnimationEvent> {
        private Map<Animation, AnimationJob> myAnimationMap = new HashMap<Animation, AnimationJob>();

        public void handleEvent(AnimationEvent event) {
            if (event == null) {
                theLogger.warning("Ignoring null AnimaionEvent.");
                return;
            }
            Animation anim = event.getAnimation();
            if (anim == null) {
                theLogger.warning("Ignoring null Animaion from AnimationEvent.");
                return;
            }
            if (RemoteAnimationPlayerHost.this.myAnimationPlayer == null) {
                theLogger.warning("Animation Player is null.  Ignoring AnimaionEvent.");
                return;
            }
            if ("CLEAR".equals(event.getDestinationId())) {
                theLogger.log(Level.INFO, "Clearing all animations from AnimationPlayer: {0}.", RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId());
                List<AnimationJob> jobs = RemoteAnimationPlayerHost.this.myAnimationPlayer.getCurrentAnimations();
                if (jobs == null) {
                    return;
                }
                for (AnimationJob job : jobs) {
                    if (job == null) continue;
                    RemoteAnimationPlayerHost.this.myAnimationPlayer.removeAnimationJob(job);
                }
                return;
            }
            AnimationJob job = this.myAnimationMap.get(anim);
            if ("STOP".equals(event.getDestinationId())) {
                if (job != null) {
                    theLogger.log(Level.INFO, "Stopping Animation: {0}, from AnimationPlayer: {1}.", new Object[]{anim.getVersion().display(), RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId()});
                    job.stop(TimeUtils.now());
                } else {
                    theLogger.log(Level.INFO, "Could not find Animation to stop: {0}, from AnimationPlayer: {1}.", new Object[]{anim.getVersion().display(), RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId()});
                }
                return;
            }
            if (job == null) {
                job = RemoteAnimationPlayerHost.this.myAnimationPlayer.playAnimation(event.getAnimation());
            } else if (PlayState.RUNNING != job.getPlayState()) {
                job.start(TimeUtils.now());
            }
            boolean loop = "LOOP".equals(event.getDestinationId());
            job.setLoop(loop);
            String msg = loop ? "Looping" : "Playing";
            theLogger.log(Level.INFO, "{0} Animation: {1}, from AnimationPlayer: {2}.", new Object[]{msg, anim.getVersion().display(), RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId()});
            this.myAnimationMap.put(anim, job);
        }
    }

    public class AnimationEventPlayer
    implements Listener<AnimationEvent> {
        public void handleEvent(AnimationEvent event) {
            if (event == null) {
                theLogger.warning("Ignoring null AnimaionEvent.");
                return;
            }
            Animation anim = event.getAnimation();
            if (anim == null) {
                theLogger.warning("Ignoring null Animaion from AnimationEvent.");
                return;
            }
            if (RemoteAnimationPlayerHost.this.myAnimationPlayer == null) {
                theLogger.warning("Animation Player is null.  Ignoring AnimaionEvent.");
                return;
            }
            theLogger.log(Level.INFO, "Sending Animation: {0}, to AnimationPlayer: {1}.", new Object[]{anim.getVersion().display(), RemoteAnimationPlayerHost.this.myAnimationPlayer.getAnimationPlayerId()});
            RemoteAnimationPlayerHost.this.myAnimationPlayer.playAnimation(event.getAnimation());
        }
    }
}

