/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerHost;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;

public class AnimationPlayerHostLifecycle
extends AbstractLifecycleProvider<RemoteAnimationPlayerHost, RemoteAnimationPlayerHost> {
    private static final String theAnimationPlayer = "animPlayer";
    private static final String theAnimationReceiver = "animLibrary";
    private static final String theSignalSender = "signalSender";

    public AnimationPlayerHostLifecycle(String animPlayerId, String animReceiverId, String signalSenderId) {
        super(new DescriptorListBuilder().dependency(theAnimationPlayer, AnimationPlayer.class).with("animationPlayerId", animPlayerId).dependency(theAnimationReceiver, MessageAsyncReceiver.class).with("messageReceiverId", animReceiverId).with("messageType", AnimationEvent.class.getName()).dependency(theSignalSender, MessageSender.class).with("messageSenderId", signalSenderId).with("messageType", AnimationSignal.class.getName()).getDescriptors());
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("animationPlayerId", animPlayerId);
    }

    protected RemoteAnimationPlayerHost create(Map<String, Object> dependencies) {
        AnimationPlayer player = (AnimationPlayer)dependencies.get(theAnimationPlayer);
        MessageAsyncReceiver eventReceiver = (MessageAsyncReceiver)dependencies.get(theAnimationReceiver);
        MessageSender sender = (MessageSender)dependencies.get(theSignalSender);
        RemoteAnimationPlayerHost host = new RemoteAnimationPlayerHost();
        host.setAnimationPlayer(player);
        host.setAnimationReceiver((MessageAsyncReceiver<AnimationEvent>)eventReceiver);
        host.setSignalSender((MessageSender<AnimationSignal>)sender);
        return host;
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theAnimationPlayer.equals(name)) {
            ((RemoteAnimationPlayerHost)this.myService).setAnimationPlayer((AnimationPlayer)dependency);
        } else if (theAnimationReceiver.equals(name)) {
            ((RemoteAnimationPlayerHost)this.myService).setAnimationReceiver((MessageAsyncReceiver<AnimationEvent>)((MessageAsyncReceiver)dependency));
        } else if (theSignalSender.equals(name)) {
            ((RemoteAnimationPlayerHost)this.myService).setSignalSender((MessageSender<AnimationSignal>)((MessageSender)dependency));
        }
    }

    public Class<RemoteAnimationPlayerHost> getServiceClass() {
        return RemoteAnimationPlayerHost.class;
    }
}

