/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.features;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.features.EditorFeature;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.property.PropertyChangeNotifier;

public class AnimationTimeRange
extends PropertyChangeNotifier
implements EditorFeature<AnimationEditor> {
    private static final Logger theLogger = Logger.getLogger(AnimationTimeRange.class.getName());
    public static final String PROP_START_TIME = "startTime";
    public static final String PROP_STOP_TIME = "stopTime";
    private AnimationEditor myEditor;
    private Long myStartTime;
    private Long myStopTime;

    public void setEditor(AnimationEditor editor) {
        this.myEditor = editor;
    }

    public void setStartTime(Long time) {
        Long old = this.myStartTime;
        this.myStartTime = time;
        this.firePropertyChange(PROP_START_TIME, old, this.myStartTime);
    }

    public Long getStartTime() {
        return this.myStartTime;
    }

    public void setStopTime(Long time) {
        Long old = this.myStopTime;
        this.myStopTime = time;
        this.firePropertyChange(PROP_STOP_TIME, old, this.myStopTime);
    }

    public Long getStopTime() {
        return this.myStopTime;
    }

    public SetStartAction getSetStartAction(Long time) {
        return new SetStartAction(time);
    }

    public SetStopAction getSetStopAction(Long time) {
        return new SetStopAction(time);
    }

    public PlayAction getPlayAction(Long time) {
        if (this.myEditor == null) {
            return null;
        }
        return new PlayAction();
    }

    public Animation getAnimationSegment() {
        if (this.myEditor == null) {
            return null;
        }
        Animation anim = this.myEditor.getEnabledAnimation();
        anim.setStartTime(this.myStartTime);
        anim.setStopTime(this.myStopTime);
        return anim;
    }

    public class PlayAction
    implements ActionListener {
        private PlayAction() {
            if (AnimationTimeRange.this.myEditor == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnimationTimeRange.this.myEditor == null) {
                return;
            }
            this.play();
        }

        private void play() {
            BundleContext context = OSGiUtils.getBundleContext(AnimationPlayer.class);
            if (context == null) {
                theLogger.log(Level.SEVERE, "Unable to find BundleContext for AnimationPlayer");
                return;
            }
            AnimationUtils.playAnimation(context, null, AnimationTimeRange.this.myEditor.getEnabledAnimation(), AnimationTimeRange.this.myStartTime, AnimationTimeRange.this.myStopTime);
        }
    }

    public class SetStopAction
    implements ActionListener {
        private Long myTime;

        private SetStopAction(Long time) {
            this.myTime = time;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationTimeRange.this.setStopTime(this.myTime);
        }
    }

    public class SetStartAction
    implements ActionListener {
        private Long myTime;

        private SetStartAction(Long time) {
            this.myTime = time;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationTimeRange.this.setStartTime(this.myTime);
        }
    }
}

