/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Source;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.common.osgi.OSGiUtils;

public class AnimationPlayerAction {
    private static final Logger theLogger = Logger.getLogger(AnimationPlayerAction.class.getName());

    public static class Stop
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class Resume
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class Pause
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class Play
    implements ActionListener {
        private Source<AnimationEditor> mySource;

        public Play(Source<AnimationEditor> source) {
            this.mySource = source;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationEditor controller = (AnimationEditor)((Object)this.mySource.getValue());
            if (controller == null) {
                return;
            }
            BundleContext context = OSGiUtils.getBundleContext(AnimationPlayer.class);
            if (context == null) {
                theLogger.log(Level.SEVERE, "Unable to find BundleContext for AnimationPlayer");
                return;
            }
            ServiceReference ref = AnimationUtils.getAnimationPlayerReference(context, null);
            if (ref == null) {
                return;
            }
            AnimationPlayer player = (AnimationPlayer)context.getService(ref);
            if (player != null) {
                Animation anim = controller.getEnabledAnimation();
                player.playAnimation(anim);
            }
            context.ungetService(ref);
        }
    }
}

