/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.animation.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum EditState {
    VISIBLE(1),
    HOVER(2),
    SELECTED(4),
    LOCKED(8),
    DISABLED(16),
    CHANGE(32);

    private static boolean[] theActionStates;
    private int myFlag;

    private EditState(int flag) {
        this.myFlag = flag;
    }

    public Integer getFlag() {
        return this.myFlag;
    }

    public static int getFlags(EditState ... stats) {
        int flags = 0;
        for (EditState s : stats) {
            flags |= s.getFlag().intValue();
        }
        return flags;
    }

    public static List<EditState> getFlags(int flags) {
        if ((long)flags == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EditState> vals = new ArrayList<EditState>(Integer.bitCount(flags));
        while (flags != 0) {
            int flag = Integer.numberOfTrailingZeros(flags);
            flags = (int)((long)flags - (1L << flag));
            vals.add(EditState.values()[flag]);
        }
        return vals;
    }

    public static List<String> getFlagNames(int flags) {
        if ((long)flags == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> vals = new ArrayList<String>(Integer.bitCount(flags));
        while (flags != 0) {
            int flag = Integer.numberOfTrailingZeros(flags);
            flags = (int)((long)flags - (1L << flag));
            vals.add(EditState.values()[flag].toString());
        }
        return vals;
    }

    public static boolean hasFlag(int flags, EditState state) {
        return (flags & state.getFlag()) == state.getFlag();
    }

    public static int setFlag(int flags, EditState state) {
        return flags | state.getFlag();
    }

    public static boolean isActionState(EditState state) {
        return theActionStates[Integer.numberOfTrailingZeros(state.getFlag())];
    }

    static {
        theActionStates = new boolean[]{true, false, false, true, true, false};
    }
}

