/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.schedule;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.node.DefaultProducerNode;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.util.DefaultNotifier;
import org.jflux.api.schedule.ScheduleNode;

public class HeartbeatNode<T>
extends DefaultProducerNode<T>
implements ScheduleNode<T, TimeUnit> {
    private static final Logger theLogger = Logger.getLogger(HeartbeatNode.class.getName());
    private Source<T> myFactory;
    private ScheduledExecutorService myExecutor;
    private long myInitialDelay;
    private long myPeriod;
    private TimeUnit myTimeUnit;
    private ScheduledFuture<?> myFuture;

    public HeartbeatNode(Source<T> factory, long initialDelay, long period, TimeUnit timeUnit) {
        super((Notifier)new DefaultNotifier());
        if (factory == null || timeUnit == null) {
            throw new NullPointerException();
        }
        this.myInitialDelay = initialDelay;
        this.myPeriod = period;
        this.myTimeUnit = timeUnit;
        this.myFactory = factory;
    }

    public synchronized void setPeriod(long period) {
        this.myPeriod = period;
        if (Playable.PlayState.RUNNING != this.getPlayState()) {
            return;
        }
        long delay = this.myInitialDelay;
        this.myInitialDelay = 0L;
        this.pause();
        this.start();
        this.myInitialDelay = delay;
    }

    public boolean start() {
        if (this.myFuture != null) {
            if (this.myFuture.isDone()) {
                this.myFuture = null;
            } else {
                return true;
            }
        }
        if (this.myExecutor == null) {
            this.myExecutor = new ScheduledThreadPoolExecutor(1);
        }
        this.myFuture = this.myExecutor.scheduleAtFixedRate(new MessagePump(), this.myInitialDelay, this.myPeriod, this.myTimeUnit);
        return super.start();
    }

    public boolean pause() {
        if (this.myFuture != null) {
            this.myFuture.cancel(false);
            this.myFuture = null;
        }
        return super.pause();
    }

    public boolean resume() {
        return this.start();
    }

    public boolean stop() {
        if (this.myFuture != null) {
            this.myFuture.cancel(false);
            this.myFuture = null;
            this.myExecutor.shutdown();
            this.myExecutor = null;
        }
        return super.stop();
    }

    class MessagePump
    implements Runnable {
        MessagePump() {
        }

        @Override
        public void run() {
            if (HeartbeatNode.this.myFactory == null || HeartbeatNode.this.getPlayState() != Playable.PlayState.RUNNING) {
                return;
            }
            Object t = HeartbeatNode.this.myFactory.getValue();
            Notifier n = HeartbeatNode.this.getNotifier();
            if (n == null || t == null) {
                return;
            }
            try {
                n.notifyListeners(t);
            }
            catch (RuntimeException ex) {
                theLogger.log(Level.WARNING, "Runtime Exception in Heartbeat Node");
            }
        }
    }
}

