/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.encode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jflux.api.core.Adapter;

public class BytesUtils {
    public static Adapter<ByteArrayOutputStream, ByteBuffer> outputStreamToBuffer() {
        return new OutputStreamToBuffer();
    }

    public static Adapter<ByteBuffer, ByteArrayInputStream> bufferToInputStream() {
        return new BufferToInputStream();
    }

    public static Adapter<ByteArrayOutputStream, ByteArrayInputStream> outputStreamToInputStream() {
        return new OutputStreamToInputStream();
    }

    public static class OutputStreamToInputStream
    implements Adapter<ByteArrayOutputStream, ByteArrayInputStream> {
        public ByteArrayInputStream adapt(ByteArrayOutputStream a) {
            return new ByteArrayInputStream(a.toByteArray());
        }
    }

    public static class BufferToInputStream
    implements Adapter<ByteBuffer, ByteArrayInputStream> {
        public ByteArrayInputStream adapt(ByteBuffer a) {
            return new ByteArrayInputStream(a.array());
        }
    }

    public static class OutputStreamToBuffer
    implements Adapter<ByteArrayOutputStream, ByteBuffer> {
        public ByteBuffer adapt(ByteArrayOutputStream a) {
            return ByteBuffer.wrap(a.toByteArray());
        }
    }
}

