/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.data.routing;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.util.MapAdapter;

public interface Router<T>
extends Listener<T> {
    public static final Logger theLogger = Logger.getLogger(Router.class.getName());

    public static class DefaultRouter<K, T>
    implements Router<T> {
        private Adapter<T, K> myKeyAdapter;
        private MapAdapter<K, Listener<T>> myRouteMap;

        public DefaultRouter(Adapter<T, K> keyAdapter) {
            if (keyAdapter == null) {
                throw new NullPointerException();
            }
            this.myRouteMap = new MapAdapter();
            this.myKeyAdapter = keyAdapter;
        }

        public void handleEvent(T event) {
            Object key = this.myKeyAdapter.adapt(event);
            Listener route = (Listener)this.myRouteMap.adapt(key);
            route.handleEvent(event);
        }

        public void addRoute(K key, Listener<T> route) {
            if (this.myRouteMap.getMap().containsKey(key)) {
                theLogger.log(Level.INFO, "Replacing existing route for key: {0}", key);
            } else {
                theLogger.log(Level.INFO, "Adding router path for key: {0}", key);
            }
            this.myRouteMap.getMap().put(key, route);
        }

        public void removeRoute(K key) {
            theLogger.log(Level.INFO, "Removing router path for key: {0}", key);
            this.myRouteMap.getMap().remove(key);
        }
    }
}

