/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.data.concurrent;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.playable.PlayableNotifier;

public class AsyncAdapter<A, B>
implements Adapter<A, PlayableNotifier<B>> {
    private Adapter<A, B> myAdapter;

    public AsyncAdapter(Adapter<A, B> adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
    }

    public PlayableNotifier<B> adapt(A a) {
        return new FutureAdapt<A, B>(a, this.myAdapter);
    }

    private class FutureAdapt<A, B>
    extends PlayableNotifier.DefaultPlayableNotifier<B>
    implements PlayableNotifier<B> {
        private final A myInput;
        private final Adapter<A, B> myAdapter;
        private final Thread myThread;

        public FutureAdapt(A input, Adapter<A, B> adapter) {
            this.myInput = input;
            this.myAdapter = adapter;
            this.myThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Object b = FutureAdapt.this.myAdapter.adapt(FutureAdapt.this.myInput);
                    FutureAdapt.this.notifyListeners(b);
                    FutureAdapt.this.complete();
                }
            });
        }

        public boolean start() {
            if (Thread.State.NEW != this.myThread.getState() || !super.start()) {
                return false;
            }
            this.myThread.start();
            return true;
        }

        public boolean pause() {
            if (Playable.PlayState.PAUSED == this.getPlayState()) {
                return true;
            }
            if (Playable.PlayState.RUNNING != this.getPlayState()) {
                return false;
            }
            if (!super.pause()) {
                return false;
            }
            this.myThread.setPriority(1);
            return true;
        }

        public boolean resume() {
            if (Playable.PlayState.PAUSED != this.getPlayState() || !super.pause()) {
                return false;
            }
            this.myThread.setPriority(5);
            return true;
        }

        public boolean stop() {
            if (Thread.State.TERMINATED == this.myThread.getState()) {
                return true;
            }
            if (!super.stop()) {
                return false;
            }
            this.myThread.interrupt();
            return true;
        }

        protected boolean complete() {
            return super.complete();
        }
    }
}

