/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.data.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.data.buffer.Buffer;

public class CircularBuffer<V>
implements Buffer<Integer, V> {
    private List<V> myElements;
    private int myNextIndex;
    private int myTailIndex;
    private int myHeadIndex;
    private int myCapacity;
    private int mySize;
    private Source<V> myHeadSource;
    private Source<V> myTailSource;
    private Source<List<V>> myValuesSource;
    private Adapter<Integer, V> myIndexAdapter;
    private Listener<V> myAdder;

    public CircularBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than 0.");
        }
        this.myCapacity = capacity;
        this.myElements = new ArrayList<V>(this.myCapacity);
        this.myNextIndex = 0;
        this.myTailIndex = 0;
        this.myHeadIndex = 0;
        this.mySize = 0;
        this.myHeadSource = new Source<V>(){

            public V getValue() {
                return CircularBuffer.this.getHeadValue();
            }
        };
        this.myTailSource = new Source<V>(){

            public V getValue() {
                return CircularBuffer.this.getTailValue();
            }
        };
        this.myIndexAdapter = new Adapter<Integer, V>(){

            public V adapt(Integer a) {
                return CircularBuffer.this.get(a);
            }
        };
        this.myValuesSource = new Source<List<V>>(){

            public List<V> getValue() {
                List vals = CircularBuffer.this.getValueList();
                CircularBuffer.this.reset();
                return vals;
            }
        };
        this.myAdder = new Listener<V>(){

            public void handleEvent(V input) {
                CircularBuffer.this.add(input);
            }
        };
    }

    private void reset() {
        this.myTailIndex = 0;
        this.myHeadIndex = 0;
        this.myNextIndex = 0;
        this.mySize = 0;
    }

    public V get(Integer n) {
        if (n < 0 || n >= this.getSize()) {
            throw new IllegalArgumentException("Index: " + n + " out of bounds.  " + "Buffer capacity is " + this.myCapacity + ".  " + "Number of elements is " + this.getSize() + ".");
        }
        int index = (this.myHeadIndex - n) % this.myCapacity;
        return this.myElements.get(index);
    }

    public void add(V value) {
        if (this.myNextIndex < this.myCapacity && this.myNextIndex >= this.myElements.size()) {
            this.myElements.add(value);
        } else {
            this.myElements.set(this.myNextIndex, value);
        }
        if (this.mySize < this.myCapacity) {
            ++this.mySize;
        }
        boolean empty = this.myTailIndex == this.myHeadIndex;
        this.myHeadIndex = this.myNextIndex;
        this.myNextIndex = (this.myNextIndex + 1) % this.myCapacity;
        if (this.myTailIndex == this.myHeadIndex && !empty) {
            this.myTailIndex = this.myNextIndex;
        }
    }

    public V getHeadValue() {
        if (this.getSize() == 0) {
            return null;
        }
        return this.myElements.get(this.myHeadIndex);
    }

    public V getTailValue() {
        if (this.getSize() == 0) {
            return null;
        }
        return this.myElements.get(this.myTailIndex);
    }

    public List<V> getValueList() {
        int size = this.getSize();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<V> vals = new ArrayList<V>(size);
        if (this.myHeadIndex > this.myTailIndex) {
            vals.addAll(this.myElements.subList(this.myTailIndex, this.myHeadIndex + 1));
        } else {
            vals.addAll(this.myElements.subList(this.myTailIndex, size));
            vals.addAll(this.myElements.subList(0, this.myHeadIndex + 1));
        }
        return vals;
    }

    public int getSize() {
        return this.mySize;
    }

    @Override
    public Source<V> getHead() {
        return this.myHeadSource;
    }

    @Override
    public Source<V> getTail() {
        return this.myTailSource;
    }

    @Override
    public Adapter<Integer, V> getIndex() {
        return this.myIndexAdapter;
    }

    @Override
    public Source<List<V>> getValues() {
        return this.myValuesSource;
    }

    @Override
    public Listener<V> addValue() {
        return this.myAdder;
    }
}

