/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.data.blend;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Source;

public interface DataCollector<D, L>
extends Source<L> {
    public void addSource(Source<D> var1);

    public void removeSource(Source<D> var1);

    public static class DefaultCollector<D>
    implements DataCollector<D, List<D>> {
        private List<Source<D>> myDataSources = new ArrayList<Source<D>>();

        public List<D> getValue() {
            ArrayList<Object> list = new ArrayList<Object>(this.myDataSources.size());
            for (Source<D> source : this.myDataSources) {
                Object data = source.getValue();
                list.add(data);
            }
            return list;
        }

        @Override
        public void addSource(Source<D> source) {
            if (source == null) {
                throw new NullPointerException();
            }
            if (!this.myDataSources.contains(source)) {
                this.myDataSources.add(source);
            }
        }

        @Override
        public void removeSource(Source<D> source) {
            if (source == null) {
                throw new NullPointerException();
            }
            this.myDataSources.remove(source);
        }
    }
}

