/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.speech;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.robokind.api.speech.SpeechService;

public class TTSPanel
extends JPanel {
    private SpeechService myTTSEngine;
    private JButton btnCancelSpeech;
    private JButton btnSpeakAll;
    private JButton btnSpeakSelected;
    private JScrollPane jScrollPane1;
    private JTextArea txtSpeech;

    public TTSPanel() {
        this.initComponents();
    }

    public void setTTSEngine(SpeechService engine) {
        this.myTTSEngine = engine;
    }

    private void speak(String txt) {
        if (this.myTTSEngine == null) {
            return;
        }
        this.myTTSEngine.speak(txt);
    }

    private void initComponents() {
        this.btnSpeakAll = new JButton();
        this.btnSpeakSelected = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.txtSpeech = new JTextArea();
        this.btnCancelSpeech = new JButton();
        this.btnSpeakAll.setText("Speak All");
        this.btnSpeakAll.setMaximumSize(new Dimension(120, 30));
        this.btnSpeakAll.setMinimumSize(new Dimension(120, 30));
        this.btnSpeakAll.setPreferredSize(new Dimension(120, 30));
        this.btnSpeakAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSPanel.this.btnSpeakAllActionPerformed(evt);
            }
        });
        this.btnSpeakSelected.setText("Speak Selected");
        this.btnSpeakSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSPanel.this.btnSpeakSelectedActionPerformed(evt);
            }
        });
        this.txtSpeech.setColumns(20);
        this.txtSpeech.setRows(5);
        this.jScrollPane1.setViewportView(this.txtSpeech);
        this.btnCancelSpeech.setText("Cancel Speech");
        this.btnCancelSpeech.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSPanel.this.btnCancelSpeechActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnSpeakAll, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSpeakSelected, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelSpeech).addGap(38, 38, 38)).addComponent(this.jScrollPane1, -1, 405, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 95, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSpeakAll, -2, -1, -2).addComponent(this.btnSpeakSelected, -2, 30, -2).addComponent(this.btnCancelSpeech))));
    }

    private void btnSpeakAllActionPerformed(ActionEvent evt) {
        String txt = this.txtSpeech.getText();
        this.speak(txt);
    }

    private void btnSpeakSelectedActionPerformed(ActionEvent evt) {
        String txt = this.txtSpeech.getSelectedText();
        if (txt == null || txt.isEmpty()) {
            txt = this.txtSpeech.getText();
        }
        this.speak(txt);
    }

    private void btnCancelSpeechActionPerformed(ActionEvent evt) {
        if (this.myTTSEngine == null) {
            return;
        }
        this.myTTSEngine.cancelSpeech();
    }
}

