/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.speech;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.utils.RKConstants;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.messaging.RemoteSpeechServiceClient;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.speech.RemoteSpeechUtils;
import org.rwshop.swing.common.PlayControlPanel;
import org.rwshop.swing.speech.TTSPanel;

public class AQTTSPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(AQTTSPanel.class.getName());
    public static final String CONNECTION_CONFIG_ID = "speechServiceConnectionConfig";
    private static final String SPEECH_SERVICE_ID = RKConstants.DEFAULT_SPEECH_ID;
    private static final String theSpeechService = "speechService";
    private JButton btnConnect;
    private JPanel jPanel1;
    private PlayControlPanel mySpeechControl;
    private TTSPanel myTTSPanel;
    private JTextField txtBrokerAddress;

    public AQTTSPanel() {
        this.initComponents();
    }

    public void setAQTTSFacade(RemoteSpeechServiceClient speechService) {
        this.mySpeechControl.setPlayable((Playable)speechService);
        this.myTTSPanel.setTTSEngine((SpeechService)speechService);
    }

    private void initComponents() {
        this.myTTSPanel = new TTSPanel();
        this.jPanel1 = new JPanel();
        this.mySpeechControl = new PlayControlPanel();
        this.btnConnect = new JButton();
        this.txtBrokerAddress = new JTextField();
        this.btnConnect.setText("Connect");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AQTTSPanel.this.btnConnectActionPerformed(evt);
            }
        });
        this.txtBrokerAddress.setText("127.0.0.1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtBrokerAddress, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.mySpeechControl, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnConnect, -1, 33, Short.MAX_VALUE).addComponent(this.txtBrokerAddress, -2, -1, -2)).addComponent((Component)this.mySpeechControl, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(78, Short.MAX_VALUE)).addComponent(this.myTTSPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myTTSPanel, -1, 185, Short.MAX_VALUE)));
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        String broker = this.txtBrokerAddress.getText();
        this.connect(broker);
    }

    private void connect(String broker) {
        BundleContext context = OSGiUtils.getBundleContext(SpeechService.class);
        if (context == null) {
            theLogger.warning("Unable to connect speech Service.  Could not find BundleContext.");
            return;
        }
        this.bindSpeechPanel(context);
        RKMessagingConfigUtils.registerConnectionConfig((String)CONNECTION_CONFIG_ID, (String)broker, null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RemoteSpeechUtils.connect((BundleContext)context, (String)SPEECH_SERVICE_ID, (String)CONNECTION_CONFIG_ID);
    }

    private void bindSpeechPanel(BundleContext context) {
        final Listener listener = new Listener<GenericLifecycle.DependencyChange<?, SpeechService>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<?, SpeechService> event) {
                SpeechService speech = (SpeechService)event.getDependency();
                if (speech == null) {
                    AQTTSPanel.this.setAQTTSFacade(null);
                } else if (speech instanceof RemoteSpeechServiceClient) {
                    AQTTSPanel.this.setAQTTSFacade((RemoteSpeechServiceClient)speech);
                }
            }
        };
        new OSGiComponent(context, (ServiceLifecycleProvider)new GenericLifecycle(new String[]{Object.class.getName()}, Arrays.asList(new DependencyDescriptor(theSpeechService, SpeechService.class, null)), null, (Adapter)new Adapter<Map<String, Object>, Object>(){

            public Object adapt(Map<String, Object> a) {
                SpeechService speech = (SpeechService)a.get(AQTTSPanel.theSpeechService);
                if (!(speech instanceof RemoteSpeechServiceClient)) {
                    return null;
                }
                AQTTSPanel.this.setAQTTSFacade((RemoteSpeechServiceClient)speech);
                return new Object();
            }
        }, (Adapter)new Adapter<String, Listener<GenericLifecycle.DependencyChange>>(){

            public Listener<GenericLifecycle.DependencyChange> adapt(String a) {
                if (AQTTSPanel.theSpeechService.equals(a)) {
                    return listener;
                }
                return null;
            }
        }, (Listener)new Listener<Object>(){

            public void handleEvent(Object input) {
                AQTTSPanel.this.setAQTTSFacade(null);
            }
        })).start();
    }
}

