/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateLicenseImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.updater.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoupdateInfoParser
extends DefaultHandler {
    private static final String INFO_NAME = "info";
    private static final String INFO_EXT = ".xml";
    private static final String INFO_FILE = "info.xml";
    private static final String INFO_DIR = "Info";
    private static final String INFO_LOCALE = "locale";
    private final Map<String, UpdateItem> items;
    private final EntityResolver entityResolver;
    private final File nbmFile;
    private UpdateLicenseImpl currentUpdateLicenseImpl;
    private static final Logger ERR = Logger.getLogger(AutoupdateInfoParser.class.getName());
    private static final String LICENSE_ATTR_NAME = "name";
    private static final String MODULE_ATTR_CODE_NAME_BASE = "codenamebase";
    private static final String MODULE_ATTR_HOMEPAGE = "homepage";
    private static final String MODULE_ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String MODULE_ATTR_NEEDS_RESTART = "needsrestart";
    private static final String MODULE_ATTR_MODULE_AUTHOR = "moduleauthor";
    private static final String MODULE_ATTR_RELEASE_DATE = "releasedate";
    private static final String MODULE_ATTR_IS_GLOBAL = "global";
    private static final String MODULE_ATTR_TARGET_CLUSTER = "targetcluster";
    private static final String MODULE_ATTR_EAGER = "eager";
    private static final String MODULE_ATTR_AUTOLOAD = "autoload";
    private static final String MODULE_ATTR_LICENSE = "license";
    private static final String MANIFEST_ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    private static final String L10N_ATTR_LOCALE = "langcode";
    private static final String L10N_ATTR_BRANDING = "brandingcode";
    private static final String L10N_ATTR_MODULE_SPECIFICATION = "module_spec_version";
    private static final String L10N_ATTR_MODULE_MAJOR_VERSION = "module_major_version";
    private static final String L10N_ATTR_LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String L10N_ATTR_LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
    private Stack<ModuleDescriptor> currentModule = new Stack();
    private Stack<String> currentLicense = new Stack();
    private List<String> lines = new ArrayList<String>();

    private AutoupdateInfoParser(Map<String, UpdateItem> items, File nbmFile) {
        this.items = items;
        this.entityResolver = this.newEntityResolver();
        this.nbmFile = nbmFile;
    }

    private EntityResolver newEntityResolver() {
        try {
            Class.forName("org.netbeans.updater.XMLUtil");
        }
        catch (ClassNotFoundException e) {
            File netbeansHomeFile = new File(System.getProperty("netbeans.home"));
            File userdir = new File(System.getProperty("netbeans.user"));
            String updaterPath = "modules/ext/updater.jar";
            String newUpdaterPath = "update/new_updater/updater.jar";
            File updaterPlatform = new File(netbeansHomeFile, "modules/ext/updater.jar");
            File updaterUserdir = new File(userdir, "modules/ext/updater.jar");
            File newUpdaterPlatform = new File(netbeansHomeFile, "update/new_updater/updater.jar");
            File newUpdaterUserdir = new File(userdir, "update/new_updater/updater.jar");
            String message = "    org.netbeans.updater.XMLUtil is not accessible\n    platform dir = " + netbeansHomeFile.getAbsolutePath() + "\n" + "    userdir  dir = " + userdir.getAbsolutePath() + "\n" + "    updater in platform exist = " + updaterPlatform.exists() + (updaterPlatform.exists() ? ", length = " + updaterPlatform.length() + " bytes" : "") + "\n" + "    updater in userdir  exist = " + updaterUserdir.exists() + (updaterUserdir.exists() ? ", length = " + updaterUserdir.length() + " bytes" : "") + "\n" + "    new updater in platform exist = " + newUpdaterPlatform.exists() + (newUpdaterPlatform.exists() ? ", length = " + newUpdaterPlatform.length() + " bytes" : "") + "\n" + "    new updater in userdir  exist = " + newUpdaterUserdir.exists() + (newUpdaterUserdir.exists() ? ", length = " + newUpdaterUserdir.length() + " bytes" : "") + "\n";
            ERR.log(Level.WARNING, message);
        }
        return XMLUtil.createAUResolver();
    }

    public static Map<String, UpdateItem> getUpdateItems(File nbmFile) throws IOException, SAXException {
        HashMap<String, UpdateItem> items = new HashMap<String, UpdateItem>();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(AutoupdateInfoParser.getAutoupdateInfoInputStream(nbmFile), (DefaultHandler)new AutoupdateInfoParser(items, nbmFile));
        }
        catch (SAXException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        return items;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lines.add(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (ELEMENTS.valueOf(qName)) {
            case module: {
                assert (!this.currentModule.empty()) : "Premature end of module " + qName;
                this.currentModule.pop();
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                ModuleDescriptor md = this.currentModule.peek();
                assert (md != null) : "ModuleDescriptor found for " + this.nbmFile;
                StringBuffer buf = new StringBuffer();
                for (String line : this.lines) {
                    buf.append(line);
                }
                md.appendNotification(buf.toString());
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                assert (!this.currentLicense.empty()) : "Premature end of license " + qName;
                StringBuffer sb = new StringBuffer();
                for (String line : this.lines) {
                    sb.append(line);
                }
                assert (this.currentUpdateLicenseImpl != null) : "UpdateLicenseImpl found for " + this.nbmFile;
                this.currentUpdateLicenseImpl.setAgreement(sb.toString());
                this.currentLicense.pop();
                break;
            }
            default: {
                ERR.warning("Unknown element " + qName);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ERR.fine("End parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startDocument() throws SAXException {
        ERR.fine("Start parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        this.lines.clear();
        switch (ELEMENTS.valueOf(qName)) {
            case module: {
                ModuleDescriptor md = new ModuleDescriptor(this.nbmFile);
                md.appendModuleAttributes(attributes);
                this.currentModule.push(md);
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                ModuleDescriptor desc = this.currentModule.peek();
                desc.appendManifest(attributes);
                UpdateItem m = desc.createUpdateItem();
                UpdateItemImpl impl = Trampoline.SPI.impl(m);
                this.currentUpdateLicenseImpl = impl.getUpdateLicenseImpl();
                this.items.put(desc.getId(), m);
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                this.currentLicense.push(attributes.getValue(LICENSE_ATTR_NAME));
                break;
            }
            default: {
                ERR.warning("Unknown element " + qName);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(publicId, systemId);
    }

    private static Manifest getManifest(org.xml.sax.Attributes attrList) {
        Manifest mf = new Manifest();
        Attributes mfAttrs = mf.getMainAttributes();
        for (int i = 0; i < attrList.getLength(); ++i) {
            mfAttrs.put(new Attributes.Name(attrList.getQName(i)), attrList.getValue(i));
        }
        return mf;
    }

    static InputSource getAutoupdateInfoInputStream(File nbmFile) throws IOException, SAXException {
        JarFile jf = null;
        try {
            jf = new JarFile(nbmFile);
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Cannot open NBM file " + nbmFile + ": " + ex).initCause(ex);
        }
        String locale = Locale.getDefault().toString();
        ZipEntry entry = jf.getEntry("Info/locale/info_" + locale + INFO_EXT);
        if (entry == null) {
            entry = jf.getEntry("Info/info.xml");
        }
        if (entry == null) {
            throw new IllegalArgumentException("info.xml found in file " + nbmFile);
        }
        return new InputSource(new BufferedInputStream(jf.getInputStream(entry)));
    }

    private static enum ELEMENTS {
        module,
        description,
        module_notification,
        external_package,
        manifest,
        l10n,
        license;

    }

    private static class ModuleDescriptor {
        private String moduleCodeName;
        private String targetcluster;
        private String homepage;
        private String downloadSize;
        private String author;
        private String publishDate;
        private String notification;
        private Boolean needsRestart;
        private Boolean isGlobal;
        private Boolean isEager;
        private Boolean isAutoload;
        private String specVersion;
        private Manifest mf;
        private UpdateLicense lic;
        private final File nbmFile;

        public ModuleDescriptor(File nbmFile) {
            this.nbmFile = nbmFile;
        }

        public void appendModuleAttributes(org.xml.sax.Attributes module) {
            this.moduleCodeName = module.getValue(AutoupdateInfoParser.MODULE_ATTR_CODE_NAME_BASE);
            this.targetcluster = module.getValue(AutoupdateInfoParser.MODULE_ATTR_TARGET_CLUSTER);
            this.homepage = module.getValue(AutoupdateInfoParser.MODULE_ATTR_HOMEPAGE);
            this.downloadSize = module.getValue(AutoupdateInfoParser.MODULE_ATTR_DOWNLOAD_SIZE);
            this.author = module.getValue(AutoupdateInfoParser.MODULE_ATTR_MODULE_AUTHOR);
            this.publishDate = module.getValue(AutoupdateInfoParser.MODULE_ATTR_RELEASE_DATE);
            if (this.publishDate == null || this.publishDate.length() == 0) {
                this.publishDate = Utilities.formatDate(new Date(this.nbmFile.lastModified()));
            }
            String needsrestart = module.getValue(AutoupdateInfoParser.MODULE_ATTR_NEEDS_RESTART);
            String global = module.getValue(AutoupdateInfoParser.MODULE_ATTR_IS_GLOBAL);
            String eager = module.getValue(AutoupdateInfoParser.MODULE_ATTR_EAGER);
            String autoload = module.getValue(AutoupdateInfoParser.MODULE_ATTR_AUTOLOAD);
            this.needsRestart = needsrestart == null || needsrestart.trim().length() == 0 ? null : Boolean.valueOf(needsrestart);
            this.isGlobal = global == null || global.trim().length() == 0 ? null : Boolean.valueOf(global);
            this.isEager = Boolean.parseBoolean(eager);
            this.isAutoload = Boolean.parseBoolean(autoload);
            String licName = module.getValue(AutoupdateInfoParser.MODULE_ATTR_LICENSE);
            this.lic = UpdateLicense.createUpdateLicense(licName, null);
        }

        public void appendManifest(org.xml.sax.Attributes manifest) {
            this.specVersion = manifest.getValue(AutoupdateInfoParser.MANIFEST_ATTR_SPECIFICATION_VERSION);
            this.mf = AutoupdateInfoParser.getManifest(manifest);
        }

        public void appendNotification(String notification) {
            this.notification = notification;
        }

        public String getId() {
            return this.moduleCodeName + '_' + this.specVersion;
        }

        public UpdateItem createUpdateItem() {
            URL distributionUrl = null;
            try {
                distributionUrl = this.nbmFile.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                ERR.log(Level.INFO, null, ex);
            }
            UpdateItem res = UpdateItem.createModule(this.moduleCodeName, this.specVersion, distributionUrl, this.author, this.downloadSize, this.homepage, this.publishDate, null, this.mf, this.isEager, this.isAutoload, this.needsRestart, this.isGlobal, this.targetcluster, this.lic);
            UpdateItemImpl impl = Trampoline.SPI.impl(res);
            ((ModuleItem)impl).setModuleNotification(this.notification);
            return res;
        }
    }
}

