/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.nio.NioSender;

public class NioHandler
implements Runnable {
    private Receiver<ByteBuffer> _receiver;
    private SocketChannel _ch;
    private ByteBuffer _readBuf;
    private static Map<Long, NioSender> _handlers = new ConcurrentHashMap<Long, NioSender>();

    private NioHandler() {
    }

    public static final Connection connect(String host, int port, ConnectionDelegate delegate) {
        NioHandler handler = new NioHandler();
        return handler.connectInternal(host, port, delegate);
    }

    private Connection connectInternal(String host, int port, ConnectionDelegate delegate) {
        try {
            InetSocketAddress address = new InetSocketAddress(host, port);
            this._ch = SocketChannel.open();
            this._ch.socket().setReuseAddress(true);
            this._ch.configureBlocking(true);
            this._ch.socket().setTcpNoDelay(true);
            if (address != null) {
                this._ch.socket().connect(address);
            }
            while (this._ch.isConnectionPending()) {
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NioSender sender = new NioSender(this._ch);
        Connection con = new Connection();
        con.setSender(new Disassembler(sender, 65535));
        con.setConnectionDelegate(delegate);
        _handlers.put(con.getConnectionId(), sender);
        this._receiver = new InputHandler(new Assembler(con), InputHandler.State.FRAME_HDR);
        Thread t = new Thread(this);
        t.start();
        return con;
    }

    public void run() {
        this._readBuf = ByteBuffer.allocate(512);
        long read = 0L;
        while (this._ch.isConnected() && this._ch.isOpen()) {
            try {
                read = this._ch.read(this._readBuf);
                if (read <= 0L) continue;
                this._readBuf.flip();
                ByteBuffer b = ByteBuffer.allocate(this._readBuf.remaining());
                b.put(this._readBuf);
                b.flip();
                this._readBuf.clear();
                this._receiver.received(b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void startBatchingFrames(int connectionId) {
        NioSender sender = _handlers.get(connectionId);
        sender.setStartBatching();
    }
}

