/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.ReadThrottleFilterBuilder;
import org.apache.mina.filter.WriteBufferLimitFilterBuilder;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.qpid.transport.Binding;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.network.ConnectionBinding;
import org.apache.qpid.transport.network.mina.MinaSender;
import org.apache.qpid.transport.util.Functions;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaHandler<E>
implements IoHandler {
    private static final String DEFAULT_READ_BUFFER_LIMIT = "262144";
    private static final String DEFAULT_WRITE_BUFFER_LIMIT = "262144";
    private static final int MAX_RCVBUF = 65536;
    private static final Logger log = Logger.get(MinaHandler.class);
    private final Binding<E, java.nio.ByteBuffer> binding;

    private MinaHandler(Binding<E, java.nio.ByteBuffer> binding) {
        this.binding = binding;
    }

    @Override
    public void messageReceived(IoSession ssn, Object obj) {
        Attachment attachment = (Attachment)ssn.getAttachment();
        ByteBuffer buf = (ByteBuffer)obj;
        try {
            attachment.receiver.received(buf.buf());
        }
        catch (Throwable t) {
            log.error(t, "exception handling buffer %s", Functions.str(buf.buf()));
            throw new RuntimeException(t);
        }
    }

    @Override
    public void messageSent(IoSession ssn, Object obj) {
    }

    @Override
    public void exceptionCaught(IoSession ssn, Throwable e) {
        Attachment attachment = (Attachment)ssn.getAttachment();
        attachment.receiver.exception(e);
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        log.debug("Protocol session created for session " + System.identityHashCode(session), new Object[0]);
        if (Boolean.getBoolean("protectio")) {
            try {
                IoFilterChain chain = session.getFilterChain();
                session.getFilterChain().addLast("tempExecutorFilterForFilterBuilder", new ExecutorFilter());
                ReadThrottleFilterBuilder readfilter = new ReadThrottleFilterBuilder();
                readfilter.setMaximumConnectionBufferSize(Integer.parseInt(System.getProperty("qpid.read.buffer.limit", "262144")));
                readfilter.attach(chain);
                WriteBufferLimitFilterBuilder writefilter = new WriteBufferLimitFilterBuilder();
                writefilter.setMaximumConnectionBufferSize(Integer.parseInt(System.getProperty("qpid.write.buffer.limit", "262144")));
                writefilter.attach(chain);
                session.getFilterChain().remove("tempExecutorFilterForFilterBuilder");
                log.info("Using IO Read/Write Filter Protection", new Object[0]);
            }
            catch (Exception e) {
                log.error("Unable to attach IO Read/Write Filter Protection :" + e.getMessage(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionOpened(IoSession ssn) {
        log.debug("opened: %s", this);
        E endpoint = this.binding.endpoint(new MinaSender(ssn));
        Attachment<E> attachment = new Attachment<E>(endpoint, this.binding.receiver(endpoint));
        IoSession ioSession = ssn;
        synchronized (ioSession) {
            ssn.setAttachment(attachment);
            ssn.notifyAll();
        }
    }

    @Override
    public void sessionClosed(IoSession ssn) {
        log.debug("closed: %s", ssn);
        Attachment attachment = (Attachment)ssn.getAttachment();
        attachment.receiver.closed();
        ssn.setAttachment(null);
    }

    @Override
    public void sessionIdle(IoSession ssn, IdleStatus status) {
    }

    public static final void accept(String host, int port, Binding<?, java.nio.ByteBuffer> binding) throws IOException {
        MinaHandler.accept(new InetSocketAddress(host, port), binding);
    }

    public static final <E> void accept(SocketAddress address, Binding<E, java.nio.ByteBuffer> binding) throws IOException {
        SocketAcceptor acceptor = new SocketAcceptor();
        acceptor.bind(address, new MinaHandler<E>(binding));
    }

    public static final <E> E connect(String host, int port, Binding<E, java.nio.ByteBuffer> binding) {
        return MinaHandler.connect(new InetSocketAddress(host, port), binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <E> E connect(SocketAddress address, Binding<E, java.nio.ByteBuffer> binding) {
        IoSession ssn;
        Integer receiveBufferSize;
        MinaHandler<E> handler = new MinaHandler<E>(binding);
        SocketConnector connector = new SocketConnector();
        IoServiceConfig acceptorConfig = connector.getDefaultConfig();
        acceptorConfig.setThreadModel(ThreadModel.MANUAL);
        SocketSessionConfig scfg = (SocketSessionConfig)acceptorConfig.getSessionConfig();
        scfg.setTcpNoDelay(Boolean.getBoolean("amqj.tcpNoDelay"));
        Integer sendBufferSize = Integer.getInteger("amqj.sendBufferSize");
        if (sendBufferSize != null && sendBufferSize > 0) {
            scfg.setSendBufferSize(sendBufferSize);
        }
        if ((receiveBufferSize = Integer.getInteger("amqj.receiveBufferSize")) != null && receiveBufferSize > 0) {
            scfg.setReceiveBufferSize(receiveBufferSize);
        } else if (scfg.getReceiveBufferSize() > 65536) {
            scfg.setReceiveBufferSize(65536);
        }
        connector.setWorkerTimeout(0);
        ConnectFuture cf = connector.connect(address, handler);
        cf.join();
        IoSession ioSession = ssn = cf.getSession();
        synchronized (ioSession) {
            while (ssn.getAttachment() == null) {
                try {
                    ssn.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Attachment attachment = (Attachment)ssn.getAttachment();
        return attachment.endpoint;
    }

    public static final void accept(String host, int port, ConnectionDelegate delegate) throws IOException {
        MinaHandler.accept(host, port, ConnectionBinding.get(delegate));
    }

    public static final Connection connect(String host, int port, ConnectionDelegate delegate) {
        return MinaHandler.connect(host, port, ConnectionBinding.get(delegate));
    }

    static {
        ByteBuffer.setAllocator(new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers(Boolean.getBoolean("amqj.enableDirectBuffers"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Attachment<E> {
        E endpoint;
        Receiver<java.nio.ByteBuffer> receiver;

        Attachment(E endpoint, Receiver<java.nio.ByteBuffer> receiver) {
            this.endpoint = endpoint;
            this.receiver = receiver;
        }
    }
}

