/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.thread.Threading;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.io.IoContext;
import org.apache.qpid.transport.util.Functions;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoSender
implements Runnable,
Sender<ByteBuffer> {
    private static final Logger log = Logger.get(IoSender.class);
    private static final int START = 0x7FFFFFF5;
    private final IoContext ioCtx;
    private final long timeout;
    private final Socket socket;
    private final OutputStream out;
    private final byte[] buffer;
    private volatile int head = 0x7FFFFFF5;
    private volatile int tail = 0x7FFFFFF5;
    private volatile boolean idle = true;
    private final Object notFull = new Object();
    private final Object notEmpty = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Thread senderThread;
    private volatile Throwable exception = null;

    public IoSender(IoContext ioCtx, int bufferSize, long timeout) {
        this.ioCtx = ioCtx;
        this.socket = ioCtx.getSocket();
        this.buffer = new byte[IoSender.pof2(bufferSize)];
        this.timeout = timeout;
        try {
            this.out = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new TransportException("Error getting output stream for socket", e);
        }
        try {
            this.senderThread = Threading.getThreadFactory().createThread(this);
        }
        catch (Exception e) {
            throw new Error("Error creating IOSender thread", e);
        }
        this.senderThread.setDaemon(true);
        this.senderThread.setName(String.format("IoSender - %s", this.socket.getRemoteSocketAddress()));
        this.senderThread.start();
    }

    private static final int pof2(int n) {
        int result;
        for (result = 1; result < n; result *= 2) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buf) {
        if (this.closed.get()) {
            throw new SenderException("sender is closed", this.exception);
        }
        int size = this.buffer.length;
        int remaining = buf.remaining();
        while (remaining > 0) {
            int hd = this.head;
            int tl = this.tail;
            if (hd - tl >= size) {
                this.flush();
                Object object = this.notFull;
                synchronized (object) {
                    long start = System.currentTimeMillis();
                    for (long elapsed = 0L; !this.closed.get() && this.head - this.tail >= size && elapsed < this.timeout; elapsed += System.currentTimeMillis() - start) {
                        try {
                            this.notFull.wait(this.timeout - elapsed);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.closed.get()) {
                        throw new SenderException("sender is closed", this.exception);
                    }
                    if (this.head - this.tail >= size) {
                        throw new SenderException(String.format("write timed out: %s, %s", this.head, this.tail));
                    }
                    continue;
                }
            }
            int hd_idx = Functions.mod(hd, size);
            int tl_idx = Functions.mod(tl, size);
            int length = tl_idx > hd_idx ? Math.min(tl_idx - hd_idx, remaining) : Math.min(size - hd_idx, remaining);
            buf.get(this.buffer, hd_idx, length);
            this.head += length;
            remaining -= length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.idle) {
            Object object = this.notEmpty;
            synchronized (object) {
                this.notEmpty.notify();
            }
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean reportException) {
        if (!this.closed.getAndSet(true)) {
            Object object = this.notFull;
            synchronized (object) {
                this.notFull.notify();
            }
            object = this.notEmpty;
            synchronized (object) {
                this.notEmpty.notify();
            }
            try {
                if (Thread.currentThread() != this.senderThread) {
                    this.senderThread.join(this.timeout);
                    if (this.senderThread.isAlive()) {
                        throw new SenderException("join timed out");
                    }
                }
                this.ioCtx.getReceiver().close(false);
            }
            catch (InterruptedException e) {
                throw new SenderException(e);
            }
            if (reportException && this.exception != null) {
                throw new SenderException(this.exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int size = this.buffer.length;
        while (true) {
            int tl;
            int hd;
            if ((hd = this.head) == (tl = this.tail)) {
                if (this.closed.get()) break;
                this.idle = true;
                Object object = this.notEmpty;
                synchronized (object) {
                    while (this.head == this.tail && !this.closed.get()) {
                        try {
                            this.notEmpty.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                this.idle = false;
                continue;
            }
            int hd_idx = Functions.mod(hd, size);
            int tl_idx = Functions.mod(tl, size);
            int length = tl_idx < hd_idx ? hd_idx - tl_idx : size - tl_idx;
            try {
                this.out.write(this.buffer, tl_idx, length);
            }
            catch (IOException e) {
                log.error(e, "error in write thread", new Object[0]);
                this.exception = e;
                this.close(false);
                break;
            }
            this.tail += length;
            if (this.head - tl < size) continue;
            Object object = this.notFull;
            synchronized (object) {
                this.notFull.notify();
            }
        }
    }

    @Override
    public void setIdleTimeout(int i) {
        try {
            this.socket.setSoTimeout(i);
        }
        catch (Exception e) {
            throw new SenderException(e);
        }
    }
}

